/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.HsmStatus;

public class HsmStatusUnmarshaller
implements Unmarshaller<HsmStatus, StaxUnmarshallerContext> {
    private static HsmStatusUnmarshaller INSTANCE;

    public HsmStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        HsmStatus.Builder hsmStatus = HsmStatus.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HsmClientCertificateIdentifier", targetDepth)) {
                    hsmStatus.hsmClientCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HsmConfigurationIdentifier", targetDepth)) {
                    hsmStatus.hsmConfigurationIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                hsmStatus.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (HsmStatus)hsmStatus.build();
    }

    public static HsmStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HsmStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

