/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroup;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class EC2SecurityGroupUnmarshaller
implements Unmarshaller<EC2SecurityGroup, StaxUnmarshallerContext> {
    private static EC2SecurityGroupUnmarshaller INSTANCE;

    public EC2SecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        EC2SecurityGroup.Builder ec2SecurityGroup;
        block8: {
            ec2SecurityGroup = EC2SecurityGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    ec2SecurityGroup.tags(tags);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Status", targetDepth)) {
                        ec2SecurityGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroupName", targetDepth)) {
                        ec2SecurityGroup.ec2SecurityGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroupOwnerId", targetDepth)) {
                        ec2SecurityGroup.ec2SecurityGroupOwnerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            ec2SecurityGroup.tags(tags);
        }
        return (EC2SecurityGroup)ec2SecurityGroup.build();
    }

    public static EC2SecurityGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EC2SecurityGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

