/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableSnapshotCopyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableSnapshotCopyRequest> {
    private final String clusterIdentifier;
    private final String destinationRegion;
    private final Integer retentionPeriod;
    private final String snapshotCopyGrantName;

    private EnableSnapshotCopyRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.destinationRegion() == null ? 0 : this.destinationRegion().hashCode());
        hashCode = 31 * hashCode + (this.retentionPeriod() == null ? 0 : this.retentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCopyGrantName() == null ? 0 : this.snapshotCopyGrantName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSnapshotCopyRequest)) {
            return false;
        }
        EnableSnapshotCopyRequest other = (EnableSnapshotCopyRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.destinationRegion() == null ^ this.destinationRegion() == null) {
            return false;
        }
        if (other.destinationRegion() != null && !other.destinationRegion().equals(this.destinationRegion())) {
            return false;
        }
        if (other.retentionPeriod() == null ^ this.retentionPeriod() == null) {
            return false;
        }
        if (other.retentionPeriod() != null && !other.retentionPeriod().equals(this.retentionPeriod())) {
            return false;
        }
        if (other.snapshotCopyGrantName() == null ^ this.snapshotCopyGrantName() == null) {
            return false;
        }
        return other.snapshotCopyGrantName() == null || other.snapshotCopyGrantName().equals(this.snapshotCopyGrantName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.destinationRegion() != null) {
            sb.append("DestinationRegion: ").append(this.destinationRegion()).append(",");
        }
        if (this.retentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.retentionPeriod()).append(",");
        }
        if (this.snapshotCopyGrantName() != null) {
            sb.append("SnapshotCopyGrantName: ").append(this.snapshotCopyGrantName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String destinationRegion;
        private Integer retentionPeriod;
        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSnapshotCopyRequest model) {
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setDestinationRegion(model.destinationRegion);
            this.setRetentionPeriod(model.retentionPeriod);
            this.setSnapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        public EnableSnapshotCopyRequest build() {
            return new EnableSnapshotCopyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableSnapshotCopyRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder destinationRegion(String var1);

        public Builder retentionPeriod(Integer var1);

        public Builder snapshotCopyGrantName(String var1);
    }
}

