/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.ClusterVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClusterVersionsResponse> {
    private final String marker;
    private final List<ClusterVersion> clusterVersions;

    private DescribeClusterVersionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.clusterVersions = builder.clusterVersions;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterVersion> clusterVersions() {
        return this.clusterVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.clusterVersions() == null ? 0 : this.clusterVersions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsResponse)) {
            return false;
        }
        DescribeClusterVersionsResponse other = (DescribeClusterVersionsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.clusterVersions() == null ^ this.clusterVersions() == null) {
            return false;
        }
        return other.clusterVersions() == null || other.clusterVersions().equals(this.clusterVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.clusterVersions() != null) {
            sb.append("ClusterVersions: ").append(this.clusterVersions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterVersion> clusterVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsResponse model) {
            this.setMarker(model.marker);
            this.setClusterVersions(model.clusterVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterVersion> getClusterVersions() {
            return this.clusterVersions;
        }

        @Override
        public final Builder clusterVersions(Collection<ClusterVersion> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(ClusterVersion ... clusterVersions) {
            this.clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        public final void setClusterVersions(Collection<ClusterVersion> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copy(clusterVersions);
        }

        @SafeVarargs
        public final void setClusterVersions(ClusterVersion ... clusterVersions) {
            this.clusterVersions(Arrays.asList(clusterVersions));
        }

        public DescribeClusterVersionsResponse build() {
            return new DescribeClusterVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterVersionsResponse> {
        public Builder marker(String var1);

        public Builder clusterVersions(Collection<ClusterVersion> var1);

        public Builder clusterVersions(ClusterVersion ... var1);
    }
}

