/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteClusterRequest> {
    private final String clusterIdentifier;
    private final Boolean skipFinalClusterSnapshot;
    private final String finalClusterSnapshotIdentifier;

    private DeleteClusterRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.skipFinalClusterSnapshot = builder.skipFinalClusterSnapshot;
        this.finalClusterSnapshotIdentifier = builder.finalClusterSnapshotIdentifier;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Boolean skipFinalClusterSnapshot() {
        return this.skipFinalClusterSnapshot;
    }

    public String finalClusterSnapshotIdentifier() {
        return this.finalClusterSnapshotIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.skipFinalClusterSnapshot() == null ? 0 : this.skipFinalClusterSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.finalClusterSnapshotIdentifier() == null ? 0 : this.finalClusterSnapshotIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterRequest)) {
            return false;
        }
        DeleteClusterRequest other = (DeleteClusterRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.skipFinalClusterSnapshot() == null ^ this.skipFinalClusterSnapshot() == null) {
            return false;
        }
        if (other.skipFinalClusterSnapshot() != null && !other.skipFinalClusterSnapshot().equals(this.skipFinalClusterSnapshot())) {
            return false;
        }
        if (other.finalClusterSnapshotIdentifier() == null ^ this.finalClusterSnapshotIdentifier() == null) {
            return false;
        }
        return other.finalClusterSnapshotIdentifier() == null || other.finalClusterSnapshotIdentifier().equals(this.finalClusterSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.skipFinalClusterSnapshot() != null) {
            sb.append("SkipFinalClusterSnapshot: ").append(this.skipFinalClusterSnapshot()).append(",");
        }
        if (this.finalClusterSnapshotIdentifier() != null) {
            sb.append("FinalClusterSnapshotIdentifier: ").append(this.finalClusterSnapshotIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private Boolean skipFinalClusterSnapshot;
        private String finalClusterSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterRequest model) {
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setSkipFinalClusterSnapshot(model.skipFinalClusterSnapshot);
            this.setFinalClusterSnapshotIdentifier(model.finalClusterSnapshotIdentifier);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Boolean getSkipFinalClusterSnapshot() {
            return this.skipFinalClusterSnapshot;
        }

        @Override
        public final Builder skipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
            return this;
        }

        public final void setSkipFinalClusterSnapshot(Boolean skipFinalClusterSnapshot) {
            this.skipFinalClusterSnapshot = skipFinalClusterSnapshot;
        }

        public final String getFinalClusterSnapshotIdentifier() {
            return this.finalClusterSnapshotIdentifier;
        }

        @Override
        public final Builder finalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
            return this;
        }

        public final void setFinalClusterSnapshotIdentifier(String finalClusterSnapshotIdentifier) {
            this.finalClusterSnapshotIdentifier = finalClusterSnapshotIdentifier;
        }

        public DeleteClusterRequest build() {
            return new DeleteClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteClusterRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder skipFinalClusterSnapshot(Boolean var1);

        public Builder finalClusterSnapshotIdentifier(String var1);
    }
}

