/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.ResizeClusterRequest;

public class ResizeClusterRequestMarshaller
implements Marshaller<Request<ResizeClusterRequest>, ResizeClusterRequest> {
    public Request<ResizeClusterRequest> marshall(ResizeClusterRequest resizeClusterRequest) {
        if (resizeClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resizeClusterRequest, "RedshiftClient");
        request.addParameter("Action", "ResizeCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resizeClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)resizeClusterRequest.clusterIdentifier()));
        }
        if (resizeClusterRequest.clusterType() != null) {
            request.addParameter("ClusterType", StringConversion.fromString((String)resizeClusterRequest.clusterType()));
        }
        if (resizeClusterRequest.nodeType() != null) {
            request.addParameter("NodeType", StringConversion.fromString((String)resizeClusterRequest.nodeType()));
        }
        if (resizeClusterRequest.numberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringConversion.fromInteger((Integer)resizeClusterRequest.numberOfNodes()));
        }
        if (resizeClusterRequest.classic() != null) {
            request.addParameter("Classic", StringConversion.fromBoolean((Boolean)resizeClusterRequest.classic()));
        }
        return request;
    }
}

