/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;

public class DescribeHsmClientCertificatesRequestMarshaller
implements Marshaller<Request<DescribeHsmClientCertificatesRequest>, DescribeHsmClientCertificatesRequest> {
    public Request<DescribeHsmClientCertificatesRequest> marshall(DescribeHsmClientCertificatesRequest describeHsmClientCertificatesRequest) {
        if (describeHsmClientCertificatesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeHsmClientCertificatesRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeHsmClientCertificates");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeHsmClientCertificatesRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringConversion.fromString((String)describeHsmClientCertificatesRequest.hsmClientCertificateIdentifier()));
        }
        if (describeHsmClientCertificatesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeHsmClientCertificatesRequest.maxRecords()));
        }
        if (describeHsmClientCertificatesRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeHsmClientCertificatesRequest.marker()));
        }
        if (describeHsmClientCertificatesRequest.tagKeys().isEmpty() && !(describeHsmClientCertificatesRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!describeHsmClientCertificatesRequest.tagKeys().isEmpty() && !(describeHsmClientCertificatesRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = describeHsmClientCertificatesRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (describeHsmClientCertificatesRequest.tagValues().isEmpty() && !(describeHsmClientCertificatesRequest.tagValues() instanceof SdkAutoConstructList)) {
            request.addParameter("TagValues", "");
        } else if (!describeHsmClientCertificatesRequest.tagValues().isEmpty() && !(describeHsmClientCertificatesRequest.tagValues() instanceof SdkAutoConstructList)) {
            List<String> tagValuesList = describeHsmClientCertificatesRequest.tagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringConversion.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

