/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DeleteTagsRequest;

public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        if (deleteTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteTagsRequest, "RedshiftClient");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteTagsRequest.resourceName() != null) {
            request.addParameter("ResourceName", StringConversion.fromString((String)deleteTagsRequest.resourceName()));
        }
        if (deleteTagsRequest.tagKeys().isEmpty() && !(deleteTagsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            request.addParameter("TagKeys", "");
        } else if (!deleteTagsRequest.tagKeys().isEmpty() && !(deleteTagsRequest.tagKeys() instanceof SdkAutoConstructList)) {
            List<String> tagKeysList = deleteTagsRequest.tagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringConversion.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        return request;
    }
}

