/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.ClusterDbRevision;
import software.amazon.awssdk.services.redshift.model.RevisionTarget;
import software.amazon.awssdk.services.redshift.transform.RevisionTargetUnmarshaller;

public class ClusterDbRevisionUnmarshaller
implements Unmarshaller<ClusterDbRevision, StaxUnmarshallerContext> {
    private static final ClusterDbRevisionUnmarshaller INSTANCE = new ClusterDbRevisionUnmarshaller();

    public ClusterDbRevision unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClusterDbRevision.Builder clusterDbRevision;
        block8: {
            clusterDbRevision = ClusterDbRevision.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<RevisionTarget> revisionTargets = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    clusterDbRevision.revisionTargets(revisionTargets);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ClusterIdentifier", targetDepth)) {
                        clusterDbRevision.clusterIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CurrentDatabaseRevision", targetDepth)) {
                        clusterDbRevision.currentDatabaseRevision(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DatabaseRevisionReleaseDate", targetDepth)) {
                        clusterDbRevision.databaseRevisionReleaseDate(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RevisionTargets", targetDepth)) {
                        revisionTargets = new ArrayList<RevisionTarget>();
                        continue;
                    }
                    if (!context.testExpression("RevisionTargets/RevisionTarget", targetDepth)) continue;
                    revisionTargets.add(RevisionTargetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            clusterDbRevision.revisionTargets(revisionTargets);
        }
        return (ClusterDbRevision)clusterDbRevision.build();
    }

    public static ClusterDbRevisionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

