/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableSnapshotCopyRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, EnableSnapshotCopyRequest> {
    private final String clusterIdentifier;
    private final String destinationRegion;
    private final Integer retentionPeriod;
    private final String snapshotCopyGrantName;

    private EnableSnapshotCopyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    public String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyGrantName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableSnapshotCopyRequest)) {
            return false;
        }
        EnableSnapshotCopyRequest other = (EnableSnapshotCopyRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.snapshotCopyGrantName(), other.snapshotCopyGrantName());
    }

    public String toString() {
        return ToString.builder((String)"EnableSnapshotCopyRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("DestinationRegion", (Object)this.destinationRegion()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("SnapshotCopyGrantName", (Object)this.snapshotCopyGrantName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "SnapshotCopyGrantName": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyGrantName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String destinationRegion;
        private Integer retentionPeriod;
        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableSnapshotCopyRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.destinationRegion(model.destinationRegion);
            this.retentionPeriod(model.retentionPeriod);
            this.snapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableSnapshotCopyRequest build() {
            return new EnableSnapshotCopyRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, EnableSnapshotCopyRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder destinationRegion(String var1);

        public Builder retentionPeriod(Integer var1);

        public Builder snapshotCopyGrantName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

