/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotCopyGrantsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
    private final String marker;
    private final List<SnapshotCopyGrant> snapshotCopyGrants;

    private DescribeSnapshotCopyGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.snapshotCopyGrants = builder.snapshotCopyGrants;
    }

    public String marker() {
        return this.marker;
    }

    public List<SnapshotCopyGrant> snapshotCopyGrants() {
        return this.snapshotCopyGrants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyGrants());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotCopyGrantsResponse)) {
            return false;
        }
        DescribeSnapshotCopyGrantsResponse other = (DescribeSnapshotCopyGrantsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.snapshotCopyGrants(), other.snapshotCopyGrants());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSnapshotCopyGrantsResponse").add("Marker", (Object)this.marker()).add("SnapshotCopyGrants", this.snapshotCopyGrants()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "SnapshotCopyGrants": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyGrants()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SnapshotCopyGrant> snapshotCopyGrants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotCopyGrantsResponse model) {
            super(model);
            this.marker(model.marker);
            this.snapshotCopyGrants(model.snapshotCopyGrants);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SnapshotCopyGrant.Builder> getSnapshotCopyGrants() {
            return this.snapshotCopyGrants != null ? (Collection)this.snapshotCopyGrants.stream().map(SnapshotCopyGrant::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copy(snapshotCopyGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(SnapshotCopyGrant ... snapshotCopyGrants) {
            this.snapshotCopyGrants(Arrays.asList(snapshotCopyGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(Consumer<SnapshotCopyGrant.Builder> ... snapshotCopyGrants) {
            this.snapshotCopyGrants(Stream.of(snapshotCopyGrants).map(c -> (SnapshotCopyGrant)((SnapshotCopyGrant.Builder)SnapshotCopyGrant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshotCopyGrants(Collection<SnapshotCopyGrant.BuilderImpl> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copyFromBuilder(snapshotCopyGrants);
        }

        @Override
        public DescribeSnapshotCopyGrantsResponse build() {
            return new DescribeSnapshotCopyGrantsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
        public Builder marker(String var1);

        public Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> var1);

        public Builder snapshotCopyGrants(SnapshotCopyGrant ... var1);

        public Builder snapshotCopyGrants(Consumer<SnapshotCopyGrant.Builder> ... var1);
    }
}

