/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Event;
import software.amazon.awssdk.services.redshift.model.EventListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeEventsResponse> {
    private final String marker;
    private final List<Event> events;

    private DescribeEventsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.events = builder.events;
    }

    public String marker() {
        return this.marker;
    }

    public List<Event> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventsResponse").add("Marker", (Object)this.marker()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Event> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            super(model);
            this.marker(model.marker);
            this.events(model.events);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Event.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(Event::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<Event> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Event ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<Event.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (Event)((Event.Builder)Event.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<Event.BuilderImpl> events) {
            this.events = EventListCopier.copyFromBuilder(events);
        }

        @Override
        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeEventsResponse> {
        public Builder marker(String var1);

        public Builder events(Collection<Event> var1);

        public Builder events(Event ... var1);

        public Builder events(Consumer<Event.Builder> ... var1);
    }
}

