/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.MaintenanceTrack;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.TrackListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterTracksResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterTracksResponse> {
    private final List<MaintenanceTrack> maintenanceTracks;
    private final String marker;

    private DescribeClusterTracksResponse(BuilderImpl builder) {
        super(builder);
        this.maintenanceTracks = builder.maintenanceTracks;
        this.marker = builder.marker;
    }

    public List<MaintenanceTrack> maintenanceTracks() {
        return this.maintenanceTracks;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTracks());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterTracksResponse)) {
            return false;
        }
        DescribeClusterTracksResponse other = (DescribeClusterTracksResponse)((Object)obj);
        return Objects.equals(this.maintenanceTracks(), other.maintenanceTracks()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClusterTracksResponse").add("MaintenanceTracks", this.maintenanceTracks()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaintenanceTracks": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTracks()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<MaintenanceTrack> maintenanceTracks = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterTracksResponse model) {
            super(model);
            this.maintenanceTracks(model.maintenanceTracks);
            this.marker(model.marker);
        }

        public final Collection<MaintenanceTrack.Builder> getMaintenanceTracks() {
            return this.maintenanceTracks != null ? (Collection)this.maintenanceTracks.stream().map(MaintenanceTrack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder maintenanceTracks(Collection<MaintenanceTrack> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copy(maintenanceTracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceTracks(MaintenanceTrack ... maintenanceTracks) {
            this.maintenanceTracks(Arrays.asList(maintenanceTracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder> ... maintenanceTracks) {
            this.maintenanceTracks(Stream.of(maintenanceTracks).map(c -> (MaintenanceTrack)((MaintenanceTrack.Builder)MaintenanceTrack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMaintenanceTracks(Collection<MaintenanceTrack.BuilderImpl> maintenanceTracks) {
            this.maintenanceTracks = TrackListCopier.copyFromBuilder(maintenanceTracks);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeClusterTracksResponse build() {
            return new DescribeClusterTracksResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeClusterTracksResponse> {
        public Builder maintenanceTracks(Collection<MaintenanceTrack> var1);

        public Builder maintenanceTracks(MaintenanceTrack ... var1);

        public Builder maintenanceTracks(Consumer<MaintenanceTrack.Builder> ... var1);

        public Builder marker(String var1);
    }
}

