/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHsmConfigurationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateHsmConfigurationRequest> {
    private final String hsmConfigurationIdentifier;
    private final String description;
    private final String hsmIpAddress;
    private final String hsmPartitionName;
    private final String hsmPartitionPassword;
    private final String hsmServerPublicCertificate;
    private final List<Tag> tags;

    private CreateHsmConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.hsmConfigurationIdentifier = builder.hsmConfigurationIdentifier;
        this.description = builder.description;
        this.hsmIpAddress = builder.hsmIpAddress;
        this.hsmPartitionName = builder.hsmPartitionName;
        this.hsmPartitionPassword = builder.hsmPartitionPassword;
        this.hsmServerPublicCertificate = builder.hsmServerPublicCertificate;
        this.tags = builder.tags;
    }

    public String hsmConfigurationIdentifier() {
        return this.hsmConfigurationIdentifier;
    }

    public String description() {
        return this.description;
    }

    public String hsmIpAddress() {
        return this.hsmIpAddress;
    }

    public String hsmPartitionName() {
        return this.hsmPartitionName;
    }

    public String hsmPartitionPassword() {
        return this.hsmPartitionPassword;
    }

    public String hsmServerPublicCertificate() {
        return this.hsmServerPublicCertificate;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmPartitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmPartitionPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmServerPublicCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHsmConfigurationRequest)) {
            return false;
        }
        CreateHsmConfigurationRequest other = (CreateHsmConfigurationRequest)((Object)obj);
        return Objects.equals(this.hsmConfigurationIdentifier(), other.hsmConfigurationIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hsmIpAddress(), other.hsmIpAddress()) && Objects.equals(this.hsmPartitionName(), other.hsmPartitionName()) && Objects.equals(this.hsmPartitionPassword(), other.hsmPartitionPassword()) && Objects.equals(this.hsmServerPublicCertificate(), other.hsmServerPublicCertificate()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateHsmConfigurationRequest").add("HsmConfigurationIdentifier", (Object)this.hsmConfigurationIdentifier()).add("Description", (Object)this.description()).add("HsmIpAddress", (Object)this.hsmIpAddress()).add("HsmPartitionName", (Object)this.hsmPartitionName()).add("HsmPartitionPassword", (Object)this.hsmPartitionPassword()).add("HsmServerPublicCertificate", (Object)this.hsmServerPublicCertificate()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmConfigurationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmConfigurationIdentifier()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HsmIpAddress": {
                return Optional.ofNullable(clazz.cast(this.hsmIpAddress()));
            }
            case "HsmPartitionName": {
                return Optional.ofNullable(clazz.cast(this.hsmPartitionName()));
            }
            case "HsmPartitionPassword": {
                return Optional.ofNullable(clazz.cast(this.hsmPartitionPassword()));
            }
            case "HsmServerPublicCertificate": {
                return Optional.ofNullable(clazz.cast(this.hsmServerPublicCertificate()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String hsmConfigurationIdentifier;
        private String description;
        private String hsmIpAddress;
        private String hsmPartitionName;
        private String hsmPartitionPassword;
        private String hsmServerPublicCertificate;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHsmConfigurationRequest model) {
            super(model);
            this.hsmConfigurationIdentifier(model.hsmConfigurationIdentifier);
            this.description(model.description);
            this.hsmIpAddress(model.hsmIpAddress);
            this.hsmPartitionName(model.hsmPartitionName);
            this.hsmPartitionPassword(model.hsmPartitionPassword);
            this.hsmServerPublicCertificate(model.hsmServerPublicCertificate);
            this.tags(model.tags);
        }

        public final String getHsmConfigurationIdentifier() {
            return this.hsmConfigurationIdentifier;
        }

        @Override
        public final Builder hsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
            return this;
        }

        public final void setHsmConfigurationIdentifier(String hsmConfigurationIdentifier) {
            this.hsmConfigurationIdentifier = hsmConfigurationIdentifier;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getHsmIpAddress() {
            return this.hsmIpAddress;
        }

        @Override
        public final Builder hsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
            return this;
        }

        public final void setHsmIpAddress(String hsmIpAddress) {
            this.hsmIpAddress = hsmIpAddress;
        }

        public final String getHsmPartitionName() {
            return this.hsmPartitionName;
        }

        @Override
        public final Builder hsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
            return this;
        }

        public final void setHsmPartitionName(String hsmPartitionName) {
            this.hsmPartitionName = hsmPartitionName;
        }

        public final String getHsmPartitionPassword() {
            return this.hsmPartitionPassword;
        }

        @Override
        public final Builder hsmPartitionPassword(String hsmPartitionPassword) {
            this.hsmPartitionPassword = hsmPartitionPassword;
            return this;
        }

        public final void setHsmPartitionPassword(String hsmPartitionPassword) {
            this.hsmPartitionPassword = hsmPartitionPassword;
        }

        public final String getHsmServerPublicCertificate() {
            return this.hsmServerPublicCertificate;
        }

        @Override
        public final Builder hsmServerPublicCertificate(String hsmServerPublicCertificate) {
            this.hsmServerPublicCertificate = hsmServerPublicCertificate;
            return this;
        }

        public final void setHsmServerPublicCertificate(String hsmServerPublicCertificate) {
            this.hsmServerPublicCertificate = hsmServerPublicCertificate;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHsmConfigurationRequest build() {
            return new CreateHsmConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, CreateHsmConfigurationRequest> {
        public Builder hsmConfigurationIdentifier(String var1);

        public Builder description(String var1);

        public Builder hsmIpAddress(String var1);

        public Builder hsmPartitionName(String var1);

        public Builder hsmPartitionPassword(String var1);

        public Builder hsmServerPublicCertificate(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

