/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptReservedNodeExchangeRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, AcceptReservedNodeExchangeRequest> {
    private final String reservedNodeId;
    private final String targetReservedNodeOfferingId;

    private AcceptReservedNodeExchangeRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeId = builder.reservedNodeId;
        this.targetReservedNodeOfferingId = builder.targetReservedNodeOfferingId;
    }

    public String reservedNodeId() {
        return this.reservedNodeId;
    }

    public String targetReservedNodeOfferingId() {
        return this.targetReservedNodeOfferingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetReservedNodeOfferingId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptReservedNodeExchangeRequest)) {
            return false;
        }
        AcceptReservedNodeExchangeRequest other = (AcceptReservedNodeExchangeRequest)((Object)obj);
        return Objects.equals(this.reservedNodeId(), other.reservedNodeId()) && Objects.equals(this.targetReservedNodeOfferingId(), other.targetReservedNodeOfferingId());
    }

    public String toString() {
        return ToString.builder((String)"AcceptReservedNodeExchangeRequest").add("ReservedNodeId", (Object)this.reservedNodeId()).add("TargetReservedNodeOfferingId", (Object)this.targetReservedNodeOfferingId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeId()));
            }
            case "TargetReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.targetReservedNodeOfferingId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String reservedNodeId;
        private String targetReservedNodeOfferingId;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptReservedNodeExchangeRequest model) {
            super(model);
            this.reservedNodeId(model.reservedNodeId);
            this.targetReservedNodeOfferingId(model.targetReservedNodeOfferingId);
        }

        public final String getReservedNodeId() {
            return this.reservedNodeId;
        }

        @Override
        public final Builder reservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
            return this;
        }

        public final void setReservedNodeId(String reservedNodeId) {
            this.reservedNodeId = reservedNodeId;
        }

        public final String getTargetReservedNodeOfferingId() {
            return this.targetReservedNodeOfferingId;
        }

        @Override
        public final Builder targetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
            return this;
        }

        public final void setTargetReservedNodeOfferingId(String targetReservedNodeOfferingId) {
            this.targetReservedNodeOfferingId = targetReservedNodeOfferingId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptReservedNodeExchangeRequest build() {
            return new AcceptReservedNodeExchangeRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, AcceptReservedNodeExchangeRequest> {
        public Builder reservedNodeId(String var1);

        public Builder targetReservedNodeOfferingId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

