/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DeleteHsmConfigurationRequest;

public class DeleteHsmConfigurationRequestMarshaller
implements Marshaller<Request<DeleteHsmConfigurationRequest>, DeleteHsmConfigurationRequest> {
    public Request<DeleteHsmConfigurationRequest> marshall(DeleteHsmConfigurationRequest deleteHsmConfigurationRequest) {
        if (deleteHsmConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteHsmConfigurationRequest, "RedshiftClient");
        request.addParameter("Action", "DeleteHsmConfiguration");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteHsmConfigurationRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringConversion.fromString((String)deleteHsmConfigurationRequest.hsmConfigurationIdentifier()));
        }
        return request;
    }
}

