/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateClusterSecurityGroupRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateClusterSecurityGroupRequestMarshaller
implements Marshaller<Request<CreateClusterSecurityGroupRequest>, CreateClusterSecurityGroupRequest> {
    public Request<CreateClusterSecurityGroupRequest> marshall(CreateClusterSecurityGroupRequest createClusterSecurityGroupRequest) {
        if (createClusterSecurityGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createClusterSecurityGroupRequest, "RedshiftClient");
        request.addParameter("Action", "CreateClusterSecurityGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterSecurityGroupRequest.clusterSecurityGroupName() != null) {
            request.addParameter("ClusterSecurityGroupName", StringConversion.fromString((String)createClusterSecurityGroupRequest.clusterSecurityGroupName()));
        }
        if (createClusterSecurityGroupRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createClusterSecurityGroupRequest.description()));
        }
        if (createClusterSecurityGroupRequest.tags().isEmpty() && !(createClusterSecurityGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createClusterSecurityGroupRequest.tags().isEmpty() && !(createClusterSecurityGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createClusterSecurityGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

