/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.CreateClusterRequest;
import software.amazon.awssdk.services.redshift.model.Tag;

public class CreateClusterRequestMarshaller
implements Marshaller<Request<CreateClusterRequest>, CreateClusterRequest> {
    public Request<CreateClusterRequest> marshall(CreateClusterRequest createClusterRequest) {
        if (createClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createClusterRequest, "RedshiftClient");
        request.addParameter("Action", "CreateCluster");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createClusterRequest.dbName() != null) {
            request.addParameter("DBName", StringConversion.fromString((String)createClusterRequest.dbName()));
        }
        if (createClusterRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringConversion.fromString((String)createClusterRequest.clusterIdentifier()));
        }
        if (createClusterRequest.clusterType() != null) {
            request.addParameter("ClusterType", StringConversion.fromString((String)createClusterRequest.clusterType()));
        }
        if (createClusterRequest.nodeType() != null) {
            request.addParameter("NodeType", StringConversion.fromString((String)createClusterRequest.nodeType()));
        }
        if (createClusterRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringConversion.fromString((String)createClusterRequest.masterUsername()));
        }
        if (createClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)createClusterRequest.masterUserPassword()));
        }
        if (createClusterRequest.clusterSecurityGroups().isEmpty() && !(createClusterRequest.clusterSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("ClusterSecurityGroups", "");
        } else if (!createClusterRequest.clusterSecurityGroups().isEmpty() && !(createClusterRequest.clusterSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> clusterSecurityGroupsList = createClusterRequest.clusterSecurityGroups();
            int clusterSecurityGroupsListIndex = 1;
            for (String clusterSecurityGroupsListValue : clusterSecurityGroupsList) {
                if (clusterSecurityGroupsListValue != null) {
                    request.addParameter("ClusterSecurityGroups.ClusterSecurityGroupName." + clusterSecurityGroupsListIndex, StringConversion.fromString((String)clusterSecurityGroupsListValue));
                }
                ++clusterSecurityGroupsListIndex;
            }
        }
        if (createClusterRequest.vpcSecurityGroupIds().isEmpty() && !(createClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!createClusterRequest.vpcSecurityGroupIds().isEmpty() && !(createClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = createClusterRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createClusterRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringConversion.fromString((String)createClusterRequest.clusterSubnetGroupName()));
        }
        if (createClusterRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)createClusterRequest.availabilityZone()));
        }
        if (createClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)createClusterRequest.preferredMaintenanceWindow()));
        }
        if (createClusterRequest.clusterParameterGroupName() != null) {
            request.addParameter("ClusterParameterGroupName", StringConversion.fromString((String)createClusterRequest.clusterParameterGroupName()));
        }
        if (createClusterRequest.automatedSnapshotRetentionPeriod() != null) {
            request.addParameter("AutomatedSnapshotRetentionPeriod", StringConversion.fromInteger((Integer)createClusterRequest.automatedSnapshotRetentionPeriod()));
        }
        if (createClusterRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createClusterRequest.port()));
        }
        if (createClusterRequest.clusterVersion() != null) {
            request.addParameter("ClusterVersion", StringConversion.fromString((String)createClusterRequest.clusterVersion()));
        }
        if (createClusterRequest.allowVersionUpgrade() != null) {
            request.addParameter("AllowVersionUpgrade", StringConversion.fromBoolean((Boolean)createClusterRequest.allowVersionUpgrade()));
        }
        if (createClusterRequest.numberOfNodes() != null) {
            request.addParameter("NumberOfNodes", StringConversion.fromInteger((Integer)createClusterRequest.numberOfNodes()));
        }
        if (createClusterRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)createClusterRequest.publiclyAccessible()));
        }
        if (createClusterRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringConversion.fromBoolean((Boolean)createClusterRequest.encrypted()));
        }
        if (createClusterRequest.hsmClientCertificateIdentifier() != null) {
            request.addParameter("HsmClientCertificateIdentifier", StringConversion.fromString((String)createClusterRequest.hsmClientCertificateIdentifier()));
        }
        if (createClusterRequest.hsmConfigurationIdentifier() != null) {
            request.addParameter("HsmConfigurationIdentifier", StringConversion.fromString((String)createClusterRequest.hsmConfigurationIdentifier()));
        }
        if (createClusterRequest.elasticIp() != null) {
            request.addParameter("ElasticIp", StringConversion.fromString((String)createClusterRequest.elasticIp()));
        }
        if (createClusterRequest.tags().isEmpty() && !(createClusterRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createClusterRequest.tags().isEmpty() && !(createClusterRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createClusterRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createClusterRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)createClusterRequest.kmsKeyId()));
        }
        if (createClusterRequest.enhancedVpcRouting() != null) {
            request.addParameter("EnhancedVpcRouting", StringConversion.fromBoolean((Boolean)createClusterRequest.enhancedVpcRouting()));
        }
        if (createClusterRequest.additionalInfo() != null) {
            request.addParameter("AdditionalInfo", StringConversion.fromString((String)createClusterRequest.additionalInfo()));
        }
        if (createClusterRequest.iamRoles().isEmpty() && !(createClusterRequest.iamRoles() instanceof SdkAutoConstructList)) {
            request.addParameter("IamRoles", "");
        } else if (!createClusterRequest.iamRoles().isEmpty() && !(createClusterRequest.iamRoles() instanceof SdkAutoConstructList)) {
            List<String> iamRolesList = createClusterRequest.iamRoles();
            int iamRolesListIndex = 1;
            for (String iamRolesListValue : iamRolesList) {
                if (iamRolesListValue != null) {
                    request.addParameter("IamRoles.IamRoleArn." + iamRolesListIndex, StringConversion.fromString((String)iamRolesListValue));
                }
                ++iamRolesListIndex;
            }
        }
        return request;
    }
}

