/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.Subnet;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.SubnetUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class ClusterSubnetGroupUnmarshaller
implements Unmarshaller<ClusterSubnetGroup, StaxUnmarshallerContext> {
    private static final ClusterSubnetGroupUnmarshaller INSTANCE = new ClusterSubnetGroupUnmarshaller();

    public ClusterSubnetGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClusterSubnetGroup.Builder clusterSubnetGroup;
        block11: {
            clusterSubnetGroup = ClusterSubnetGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<Subnet> subnets = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    clusterSubnetGroup.subnets(subnets);
                    clusterSubnetGroup.tags(tags);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ClusterSubnetGroupName", targetDepth)) {
                        clusterSubnetGroup.clusterSubnetGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        clusterSubnetGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcId", targetDepth)) {
                        clusterSubnetGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SubnetGroupStatus", targetDepth)) {
                        clusterSubnetGroup.subnetGroupStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Subnets", targetDepth)) {
                        subnets = new ArrayList<Subnet>();
                        continue;
                    }
                    if (context.testExpression("Subnets/Subnet", targetDepth)) {
                        subnets.add(SubnetUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            clusterSubnetGroup.subnets(subnets);
            clusterSubnetGroup.tags(tags);
        }
        return (ClusterSubnetGroup)clusterSubnetGroup.build();
    }

    public static ClusterSubnetGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

