/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;

public class AuthorizeClusterSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeClusterSecurityGroupIngressRequest>, AuthorizeClusterSecurityGroupIngressRequest> {
    public Request<AuthorizeClusterSecurityGroupIngressRequest> marshall(AuthorizeClusterSecurityGroupIngressRequest authorizeClusterSecurityGroupIngressRequest) {
        if (authorizeClusterSecurityGroupIngressRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)authorizeClusterSecurityGroupIngressRequest, "RedshiftClient");
        request.addParameter("Action", "AuthorizeClusterSecurityGroupIngress");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeClusterSecurityGroupIngressRequest.clusterSecurityGroupName() != null) {
            request.addParameter("ClusterSecurityGroupName", StringConversion.fromString((String)authorizeClusterSecurityGroupIngressRequest.clusterSecurityGroupName()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringConversion.fromString((String)authorizeClusterSecurityGroupIngressRequest.cidrip()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringConversion.fromString((String)authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringConversion.fromString((String)authorizeClusterSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

