/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;

public class DescribeClustersPublisher
implements SdkPublisher<DescribeClustersResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClustersPublisher(RedshiftAsyncClient client, DescribeClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClustersPublisher(RedshiftAsyncClient client, DescribeClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Cluster> clusters() {
        Function<DescribeClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusters() != null) {
                return response.clusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeClustersPublisher resume(DescribeClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClustersPublisher(this.client, (DescribeClustersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClustersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClustersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClustersResponseFetcher
    implements AsyncPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<DescribeClustersResponse> nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersPublisher.this.client.describeClusters(DescribeClustersPublisher.this.firstRequest);
            }
            return DescribeClustersPublisher.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

