/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AccountWithRestoreAccess;
import software.amazon.awssdk.services.redshift.model.AccountsWithRestoreAccessListCopier;
import software.amazon.awssdk.services.redshift.model.RestorableNodeTypeListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Snapshot
implements ToCopyableBuilder<Builder, Snapshot> {
    private final String snapshotIdentifier;
    private final String clusterIdentifier;
    private final Instant snapshotCreateTime;
    private final String status;
    private final Integer port;
    private final String availabilityZone;
    private final Instant clusterCreateTime;
    private final String masterUsername;
    private final String clusterVersion;
    private final String snapshotType;
    private final String nodeType;
    private final Integer numberOfNodes;
    private final String dbName;
    private final String vpcId;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final Boolean encryptedWithHSM;
    private final List<AccountWithRestoreAccess> accountsWithRestoreAccess;
    private final String ownerAccount;
    private final Double totalBackupSizeInMegaBytes;
    private final Double actualIncrementalBackupSizeInMegaBytes;
    private final Double backupProgressInMegaBytes;
    private final Double currentBackupRateInMegaBytesPerSecond;
    private final Long estimatedSecondsToCompletion;
    private final Long elapsedTimeInSeconds;
    private final String sourceRegion;
    private final List<Tag> tags;
    private final List<String> restorableNodeTypes;
    private final Boolean enhancedVpcRouting;

    private Snapshot(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.masterUsername = builder.masterUsername;
        this.clusterVersion = builder.clusterVersion;
        this.snapshotType = builder.snapshotType;
        this.nodeType = builder.nodeType;
        this.numberOfNodes = builder.numberOfNodes;
        this.dbName = builder.dbName;
        this.vpcId = builder.vpcId;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.encryptedWithHSM = builder.encryptedWithHSM;
        this.accountsWithRestoreAccess = builder.accountsWithRestoreAccess;
        this.ownerAccount = builder.ownerAccount;
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
        this.actualIncrementalBackupSizeInMegaBytes = builder.actualIncrementalBackupSizeInMegaBytes;
        this.backupProgressInMegaBytes = builder.backupProgressInMegaBytes;
        this.currentBackupRateInMegaBytesPerSecond = builder.currentBackupRateInMegaBytesPerSecond;
        this.estimatedSecondsToCompletion = builder.estimatedSecondsToCompletion;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.sourceRegion = builder.sourceRegion;
        this.tags = builder.tags;
        this.restorableNodeTypes = builder.restorableNodeTypes;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Instant snapshotCreateTime() {
        return this.snapshotCreateTime;
    }

    public String status() {
        return this.status;
    }

    public Integer port() {
        return this.port;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public String dbName() {
        return this.dbName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean encryptedWithHSM() {
        return this.encryptedWithHSM;
    }

    public List<AccountWithRestoreAccess> accountsWithRestoreAccess() {
        return this.accountsWithRestoreAccess;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public Double totalBackupSizeInMegaBytes() {
        return this.totalBackupSizeInMegaBytes;
    }

    public Double actualIncrementalBackupSizeInMegaBytes() {
        return this.actualIncrementalBackupSizeInMegaBytes;
    }

    public Double backupProgressInMegaBytes() {
        return this.backupProgressInMegaBytes;
    }

    public Double currentBackupRateInMegaBytesPerSecond() {
        return this.currentBackupRateInMegaBytesPerSecond;
    }

    public Long estimatedSecondsToCompletion() {
        return this.estimatedSecondsToCompletion;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<String> restorableNodeTypes() {
        return this.restorableNodeTypes;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedWithHSM());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountsWithRestoreAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualIncrementalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupProgressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBackupRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSecondsToCompletion());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.restorableNodeTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.snapshotType(), other.snapshotType()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.encryptedWithHSM(), other.encryptedWithHSM()) && Objects.equals(this.accountsWithRestoreAccess(), other.accountsWithRestoreAccess()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes()) && Objects.equals(this.actualIncrementalBackupSizeInMegaBytes(), other.actualIncrementalBackupSizeInMegaBytes()) && Objects.equals(this.backupProgressInMegaBytes(), other.backupProgressInMegaBytes()) && Objects.equals(this.currentBackupRateInMegaBytesPerSecond(), other.currentBackupRateInMegaBytesPerSecond()) && Objects.equals(this.estimatedSecondsToCompletion(), other.estimatedSecondsToCompletion()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.sourceRegion(), other.sourceRegion()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.restorableNodeTypes(), other.restorableNodeTypes()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting());
    }

    public String toString() {
        return ToString.builder((String)"Snapshot").add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("SnapshotCreateTime", (Object)this.snapshotCreateTime()).add("Status", (Object)this.status()).add("Port", (Object)this.port()).add("AvailabilityZone", (Object)this.availabilityZone()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("MasterUsername", (Object)this.masterUsername()).add("ClusterVersion", (Object)this.clusterVersion()).add("SnapshotType", (Object)this.snapshotType()).add("NodeType", (Object)this.nodeType()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("DBName", (Object)this.dbName()).add("VpcId", (Object)this.vpcId()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("EncryptedWithHSM", (Object)this.encryptedWithHSM()).add("AccountsWithRestoreAccess", this.accountsWithRestoreAccess()).add("OwnerAccount", (Object)this.ownerAccount()).add("TotalBackupSizeInMegaBytes", (Object)this.totalBackupSizeInMegaBytes()).add("ActualIncrementalBackupSizeInMegaBytes", (Object)this.actualIncrementalBackupSizeInMegaBytes()).add("BackupProgressInMegaBytes", (Object)this.backupProgressInMegaBytes()).add("CurrentBackupRateInMegaBytesPerSecond", (Object)this.currentBackupRateInMegaBytesPerSecond()).add("EstimatedSecondsToCompletion", (Object)this.estimatedSecondsToCompletion()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).add("SourceRegion", (Object)this.sourceRegion()).add("Tags", this.tags()).add("RestorableNodeTypes", this.restorableNodeTypes()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "SnapshotCreateTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "ClusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "SnapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotType()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EncryptedWithHSM": {
                return Optional.ofNullable(clazz.cast(this.encryptedWithHSM()));
            }
            case "AccountsWithRestoreAccess": {
                return Optional.ofNullable(clazz.cast(this.accountsWithRestoreAccess()));
            }
            case "OwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "TotalBackupSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalBackupSizeInMegaBytes()));
            }
            case "ActualIncrementalBackupSizeInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.actualIncrementalBackupSizeInMegaBytes()));
            }
            case "BackupProgressInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.backupProgressInMegaBytes()));
            }
            case "CurrentBackupRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.currentBackupRateInMegaBytesPerSecond()));
            }
            case "EstimatedSecondsToCompletion": {
                return Optional.ofNullable(clazz.cast(this.estimatedSecondsToCompletion()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "RestorableNodeTypes": {
                return Optional.ofNullable(clazz.cast(this.restorableNodeTypes()));
            }
            case "EnhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String clusterIdentifier;
        private Instant snapshotCreateTime;
        private String status;
        private Integer port;
        private String availabilityZone;
        private Instant clusterCreateTime;
        private String masterUsername;
        private String clusterVersion;
        private String snapshotType;
        private String nodeType;
        private Integer numberOfNodes;
        private String dbName;
        private String vpcId;
        private Boolean encrypted;
        private String kmsKeyId;
        private Boolean encryptedWithHSM;
        private List<AccountWithRestoreAccess> accountsWithRestoreAccess = DefaultSdkAutoConstructList.getInstance();
        private String ownerAccount;
        private Double totalBackupSizeInMegaBytes;
        private Double actualIncrementalBackupSizeInMegaBytes;
        private Double backupProgressInMegaBytes;
        private Double currentBackupRateInMegaBytesPerSecond;
        private Long estimatedSecondsToCompletion;
        private Long elapsedTimeInSeconds;
        private String sourceRegion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> restorableNodeTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean enhancedVpcRouting;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.clusterIdentifier(model.clusterIdentifier);
            this.snapshotCreateTime(model.snapshotCreateTime);
            this.status(model.status);
            this.port(model.port);
            this.availabilityZone(model.availabilityZone);
            this.clusterCreateTime(model.clusterCreateTime);
            this.masterUsername(model.masterUsername);
            this.clusterVersion(model.clusterVersion);
            this.snapshotType(model.snapshotType);
            this.nodeType(model.nodeType);
            this.numberOfNodes(model.numberOfNodes);
            this.dbName(model.dbName);
            this.vpcId(model.vpcId);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.encryptedWithHSM(model.encryptedWithHSM);
            this.accountsWithRestoreAccess(model.accountsWithRestoreAccess);
            this.ownerAccount(model.ownerAccount);
            this.totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
            this.actualIncrementalBackupSizeInMegaBytes(model.actualIncrementalBackupSizeInMegaBytes);
            this.backupProgressInMegaBytes(model.backupProgressInMegaBytes);
            this.currentBackupRateInMegaBytesPerSecond(model.currentBackupRateInMegaBytesPerSecond);
            this.estimatedSecondsToCompletion(model.estimatedSecondsToCompletion);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.sourceRegion(model.sourceRegion);
            this.tags(model.tags);
            this.restorableNodeTypes(model.restorableNodeTypes);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Instant getSnapshotCreateTime() {
            return this.snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEncryptedWithHSM() {
            return this.encryptedWithHSM;
        }

        @Override
        public final Builder encryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
            return this;
        }

        public final void setEncryptedWithHSM(Boolean encryptedWithHSM) {
            this.encryptedWithHSM = encryptedWithHSM;
        }

        public final Collection<AccountWithRestoreAccess.Builder> getAccountsWithRestoreAccess() {
            return this.accountsWithRestoreAccess != null ? (Collection)this.accountsWithRestoreAccess.stream().map(AccountWithRestoreAccess::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copy(accountsWithRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(AccountWithRestoreAccess ... accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess(Arrays.asList(accountsWithRestoreAccess));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(Consumer<AccountWithRestoreAccess.Builder> ... accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess(Stream.of(accountsWithRestoreAccess).map(c -> (AccountWithRestoreAccess)((AccountWithRestoreAccess.Builder)AccountWithRestoreAccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountsWithRestoreAccess(Collection<AccountWithRestoreAccess.BuilderImpl> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountsWithRestoreAccessListCopier.copyFromBuilder(accountsWithRestoreAccess);
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return this.totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        public final Double getActualIncrementalBackupSizeInMegaBytes() {
            return this.actualIncrementalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
            return this;
        }

        public final void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        }

        public final Double getBackupProgressInMegaBytes() {
            return this.backupProgressInMegaBytes;
        }

        @Override
        public final Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
            return this;
        }

        public final void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        }

        public final Double getCurrentBackupRateInMegaBytesPerSecond() {
            return this.currentBackupRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        }

        public final Long getEstimatedSecondsToCompletion() {
            return this.estimatedSecondsToCompletion;
        }

        @Override
        public final Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
            return this;
        }

        public final void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Collection<String> getRestorableNodeTypes() {
            return this.restorableNodeTypes;
        }

        @Override
        public final Builder restorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableNodeTypes(String ... restorableNodeTypes) {
            this.restorableNodeTypes(Arrays.asList(restorableNodeTypes));
            return this;
        }

        public final void setRestorableNodeTypes(Collection<String> restorableNodeTypes) {
            this.restorableNodeTypes = RestorableNodeTypeListCopier.copy(restorableNodeTypes);
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Snapshot> {
        public Builder snapshotIdentifier(String var1);

        public Builder clusterIdentifier(String var1);

        public Builder snapshotCreateTime(Instant var1);

        public Builder status(String var1);

        public Builder port(Integer var1);

        public Builder availabilityZone(String var1);

        public Builder clusterCreateTime(Instant var1);

        public Builder masterUsername(String var1);

        public Builder clusterVersion(String var1);

        public Builder snapshotType(String var1);

        public Builder nodeType(String var1);

        public Builder numberOfNodes(Integer var1);

        public Builder dbName(String var1);

        public Builder vpcId(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder encryptedWithHSM(Boolean var1);

        public Builder accountsWithRestoreAccess(Collection<AccountWithRestoreAccess> var1);

        public Builder accountsWithRestoreAccess(AccountWithRestoreAccess ... var1);

        public Builder accountsWithRestoreAccess(Consumer<AccountWithRestoreAccess.Builder> ... var1);

        public Builder ownerAccount(String var1);

        public Builder totalBackupSizeInMegaBytes(Double var1);

        public Builder actualIncrementalBackupSizeInMegaBytes(Double var1);

        public Builder backupProgressInMegaBytes(Double var1);

        public Builder currentBackupRateInMegaBytesPerSecond(Double var1);

        public Builder estimatedSecondsToCompletion(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder sourceRegion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder restorableNodeTypes(Collection<String> var1);

        public Builder restorableNodeTypes(String ... var1);

        public Builder enhancedVpcRouting(Boolean var1);
    }
}

