/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.EventCategoriesMap;
import software.amazon.awssdk.services.redshift.model.EventCategoriesMapListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventCategoriesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeEventCategoriesResponse> {
    private final List<EventCategoriesMap> eventCategoriesMapList;

    private DescribeEventCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.eventCategoriesMapList = builder.eventCategoriesMapList;
    }

    public List<EventCategoriesMap> eventCategoriesMapList() {
        return this.eventCategoriesMapList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategoriesMapList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesResponse)) {
            return false;
        }
        DescribeEventCategoriesResponse other = (DescribeEventCategoriesResponse)((Object)obj);
        return Objects.equals(this.eventCategoriesMapList(), other.eventCategoriesMapList());
    }

    public String toString() {
        return ToString.builder((String)"DescribeEventCategoriesResponse").add("EventCategoriesMapList", this.eventCategoriesMapList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventCategoriesMapList": {
                return Optional.ofNullable(clazz.cast(this.eventCategoriesMapList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<EventCategoriesMap> eventCategoriesMapList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesResponse model) {
            super(model);
            this.eventCategoriesMapList(model.eventCategoriesMapList);
        }

        public final Collection<EventCategoriesMap.Builder> getEventCategoriesMapList() {
            return this.eventCategoriesMapList != null ? (Collection)this.eventCategoriesMapList.stream().map(EventCategoriesMap::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventCategoriesMapList(Collection<EventCategoriesMap> eventCategoriesMapList) {
            this.eventCategoriesMapList = EventCategoriesMapListCopier.copy(eventCategoriesMapList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesMapList(EventCategoriesMap ... eventCategoriesMapList) {
            this.eventCategoriesMapList(Arrays.asList(eventCategoriesMapList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategoriesMapList(Consumer<EventCategoriesMap.Builder> ... eventCategoriesMapList) {
            this.eventCategoriesMapList(Stream.of(eventCategoriesMapList).map(c -> (EventCategoriesMap)((EventCategoriesMap.Builder)EventCategoriesMap.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventCategoriesMapList(Collection<EventCategoriesMap.BuilderImpl> eventCategoriesMapList) {
            this.eventCategoriesMapList = EventCategoriesMapListCopier.copyFromBuilder(eventCategoriesMapList);
        }

        @Override
        public DescribeEventCategoriesResponse build() {
            return new DescribeEventCategoriesResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeEventCategoriesResponse> {
        public Builder eventCategoriesMapList(Collection<EventCategoriesMap> var1);

        public Builder eventCategoriesMapList(EventCategoriesMap ... var1);

        public Builder eventCategoriesMapList(Consumer<EventCategoriesMap.Builder> ... var1);
    }
}

