/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Subnet;
import software.amazon.awssdk.services.redshift.model.SubnetListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSubnetGroup
implements ToCopyableBuilder<Builder, ClusterSubnetGroup> {
    private final String clusterSubnetGroupName;
    private final String description;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;
    private final List<Tag> tags;

    private ClusterSubnetGroup(BuilderImpl builder) {
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.tags = builder.tags;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public List<Subnet> subnets() {
        return this.subnets;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSubnetGroup)) {
            return false;
        }
        ClusterSubnetGroup other = (ClusterSubnetGroup)obj;
        return Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetGroupStatus(), other.subnetGroupStatus()) && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ClusterSubnetGroup").add("ClusterSubnetGroupName", (Object)this.clusterSubnetGroupName()).add("Description", (Object)this.description()).add("VpcId", (Object)this.vpcId()).add("SubnetGroupStatus", (Object)this.subnetGroupStatus()).add("Subnets", this.subnets()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupStatus()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private String description;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSubnetGroup model) {
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.description(model.description);
            this.vpcId(model.vpcId);
            this.subnetGroupStatus(model.subnetGroupStatus);
            this.subnets(model.subnets);
            this.tags(model.tags);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        public final Collection<Subnet.Builder> getSubnets() {
            return this.subnets != null ? (Collection)this.subnets.stream().map(Subnet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (Subnet)((Subnet.Builder)Subnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ClusterSubnetGroup build() {
            return new ClusterSubnetGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSubnetGroup> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder description(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder subnets(Consumer<Subnet.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

