/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.redshift.model.AvailabilityZone;
import software.amazon.awssdk.services.redshift.model.AvailabilityZoneListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OrderableClusterOption
implements ToCopyableBuilder<Builder, OrderableClusterOption> {
    private final String clusterVersion;
    private final String clusterType;
    private final String nodeType;
    private final List<AvailabilityZone> availabilityZones;

    private OrderableClusterOption(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.clusterType = builder.clusterType;
        this.nodeType = builder.nodeType;
        this.availabilityZones = builder.availabilityZones;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String clusterType() {
        return this.clusterType;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableClusterOption)) {
            return false;
        }
        OrderableClusterOption other = (OrderableClusterOption)obj;
        return Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.clusterType(), other.clusterType()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.availabilityZones(), other.availabilityZones());
    }

    public String toString() {
        return ToString.builder((String)"OrderableClusterOption").add("ClusterVersion", (Object)this.clusterVersion()).add("ClusterType", (Object)this.clusterType()).add("NodeType", (Object)this.nodeType()).add("AvailabilityZones", this.availabilityZones()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterVersion": {
                return Optional.of(clazz.cast(this.clusterVersion()));
            }
            case "ClusterType": {
                return Optional.of(clazz.cast(this.clusterType()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "AvailabilityZones": {
                return Optional.of(clazz.cast(this.availabilityZones()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String clusterType;
        private String nodeType;
        private List<AvailabilityZone> availabilityZones;

        private BuilderImpl() {
        }

        private BuilderImpl(OrderableClusterOption model) {
            this.clusterVersion(model.clusterVersion);
            this.clusterType(model.clusterType);
            this.nodeType(model.nodeType);
            this.availabilityZones(model.availabilityZones);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Collection<AvailabilityZone.Builder> getAvailabilityZones() {
            return this.availabilityZones != null ? (Collection)this.availabilityZones.stream().map(AvailabilityZone::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZoneListCopier.copyFromBuilder(availabilityZones);
        }

        public OrderableClusterOption build() {
            return new OrderableClusterOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OrderableClusterOption> {
        public Builder clusterVersion(String var1);

        public Builder clusterType(String var1);

        public Builder nodeType(String var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);
    }
}

