/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.redshift.model.EventInfoMap;
import software.amazon.awssdk.services.redshift.model.EventInfoMapListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventCategoriesMap
implements ToCopyableBuilder<Builder, EventCategoriesMap> {
    private final String sourceType;
    private final List<EventInfoMap> events;

    private EventCategoriesMap(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.events = builder.events;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<EventInfoMap> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap)obj;
        return Objects.equals(this.sourceType(), other.sourceType()) && Objects.equals(this.events(), other.events());
    }

    public String toString() {
        return ToString.builder((String)"EventCategoriesMap").add("SourceType", (Object)this.sourceType()).add("Events", this.events()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceType()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<EventInfoMap> events;

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoriesMap model) {
            this.sourceType(model.sourceType);
            this.events(model.events);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<EventInfoMap.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(EventInfoMap::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<EventInfoMap> events) {
            this.events = EventInfoMapListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(EventInfoMap ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<EventInfoMap.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (EventInfoMap)((EventInfoMap.Builder)EventInfoMap.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<EventInfoMap.BuilderImpl> events) {
            this.events = EventInfoMapListCopier.copyFromBuilder(events);
        }

        public EventCategoriesMap build() {
            return new EventCategoriesMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventCategoriesMap> {
        public Builder sourceType(String var1);

        public Builder events(Collection<EventInfoMap> var1);

        public Builder events(EventInfoMap ... var1);

        public Builder events(Consumer<EventInfoMap.Builder> ... var1);
    }
}

