/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.redshift.model.EventCategoriesListCopier;
import software.amazon.awssdk.services.redshift.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Event
implements ToCopyableBuilder<Builder, Event> {
    private final String sourceIdentifier;
    private final String sourceType;
    private final String message;
    private final List<String> eventCategories;
    private final String severity;
    private final Instant date;
    private final String eventId;

    private Event(BuilderImpl builder) {
        this.sourceIdentifier = builder.sourceIdentifier;
        this.sourceType = builder.sourceType;
        this.message = builder.message;
        this.eventCategories = builder.eventCategories;
        this.severity = builder.severity;
        this.date = builder.date;
        this.eventId = builder.eventId;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public SourceType sourceType() {
        return SourceType.fromValue(this.sourceType);
    }

    public String sourceTypeAsString() {
        return this.sourceType;
    }

    public String message() {
        return this.message;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public String severity() {
        return this.severity;
    }

    public Instant date() {
        return this.date;
    }

    public String eventId() {
        return this.eventId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.sourceIdentifier(), other.sourceIdentifier()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.eventCategories(), other.eventCategories()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.date(), other.date()) && Objects.equals(this.eventId(), other.eventId());
    }

    public String toString() {
        return ToString.builder((String)"Event").add("SourceIdentifier", (Object)this.sourceIdentifier()).add("SourceType", (Object)this.sourceTypeAsString()).add("Message", (Object)this.message()).add("EventCategories", this.eventCategories()).add("Severity", (Object)this.severity()).add("Date", (Object)this.date()).add("EventId", (Object)this.eventId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceIdentifier": {
                return Optional.of(clazz.cast(this.sourceIdentifier()));
            }
            case "SourceType": {
                return Optional.of(clazz.cast(this.sourceTypeAsString()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
            case "EventCategories": {
                return Optional.of(clazz.cast(this.eventCategories()));
            }
            case "Severity": {
                return Optional.of(clazz.cast(this.severity()));
            }
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "EventId": {
                return Optional.of(clazz.cast(this.eventId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceIdentifier;
        private String sourceType;
        private String message;
        private List<String> eventCategories;
        private String severity;
        private Instant date;
        private String eventId;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.sourceIdentifier(model.sourceIdentifier);
            this.sourceType(model.sourceType);
            this.message(model.message);
            this.eventCategories(model.eventCategories);
            this.severity(model.severity);
            this.date(model.date);
            this.eventId(model.eventId);
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(SourceType sourceType) {
            this.sourceType(sourceType.toString());
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        public final String getSeverity() {
            return this.severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final String getEventId() {
            return this.eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public Event build() {
            return new Event(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Event> {
        public Builder sourceIdentifier(String var1);

        public Builder sourceType(String var1);

        public Builder sourceType(SourceType var1);

        public Builder message(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);

        public Builder severity(String var1);

        public Builder date(Instant var1);

        public Builder eventId(String var1);
    }
}

