/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateEventSubscriptionRequestMarshaller
implements Marshaller<Request<CreateEventSubscriptionRequest>, CreateEventSubscriptionRequest> {
    public Request<CreateEventSubscriptionRequest> marshall(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        SdkInternalList tagsList;
        SdkInternalList eventCategoriesList;
        SdkInternalList sourceIdsList;
        if (createEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEventSubscriptionRequest, "RedshiftClient");
        request.addParameter("Action", "CreateEventSubscription");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)createEventSubscriptionRequest.subscriptionName()));
        }
        if (createEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString((String)createEventSubscriptionRequest.snsTopicArn()));
        }
        if (createEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)createEventSubscriptionRequest.sourceType()));
        }
        if (!(sourceIdsList = (SdkInternalList)createEventSubscriptionRequest.sourceIds()).isEmpty() || !sourceIdsList.isAutoConstruct()) {
            int sourceIdsListIndex = 1;
            for (Object sourceIdsListValue : sourceIdsList) {
                if (sourceIdsListValue != null) {
                    request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString((String)sourceIdsListValue));
                }
                ++sourceIdsListIndex;
            }
        }
        if (!(eventCategoriesList = (SdkInternalList)createEventSubscriptionRequest.eventCategories()).isEmpty() || !eventCategoriesList.isAutoConstruct()) {
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (createEventSubscriptionRequest.severity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)createEventSubscriptionRequest.severity()));
        }
        if (createEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)createEventSubscriptionRequest.enabled()));
        }
        if (!(tagsList = (SdkInternalList)createEventSubscriptionRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

