/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSnapshotsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeClusterSnapshotsRequest> {
    private final String clusterIdentifier;
    private final String snapshotIdentifier;
    private final String snapshotType;
    private final Date startTime;
    private final Date endTime;
    private final Integer maxRecords;
    private final String marker;
    private final String ownerAccount;
    private final List<String> tagKeys;
    private final List<String> tagValues;

    private DescribeClusterSnapshotsRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotType = builder.snapshotType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.ownerAccount = builder.ownerAccount;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String snapshotType() {
        return this.snapshotType;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    public List<String> tagValues() {
        return this.tagValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotIdentifier() == null ? 0 : this.snapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.snapshotType() == null ? 0 : this.snapshotType().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.ownerAccount() == null ? 0 : this.ownerAccount().hashCode());
        hashCode = 31 * hashCode + (this.tagKeys() == null ? 0 : this.tagKeys().hashCode());
        hashCode = 31 * hashCode + (this.tagValues() == null ? 0 : this.tagValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSnapshotsRequest)) {
            return false;
        }
        DescribeClusterSnapshotsRequest other = (DescribeClusterSnapshotsRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.snapshotIdentifier() == null ^ this.snapshotIdentifier() == null) {
            return false;
        }
        if (other.snapshotIdentifier() != null && !other.snapshotIdentifier().equals(this.snapshotIdentifier())) {
            return false;
        }
        if (other.snapshotType() == null ^ this.snapshotType() == null) {
            return false;
        }
        if (other.snapshotType() != null && !other.snapshotType().equals(this.snapshotType())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.ownerAccount() == null ^ this.ownerAccount() == null) {
            return false;
        }
        if (other.ownerAccount() != null && !other.ownerAccount().equals(this.ownerAccount())) {
            return false;
        }
        if (other.tagKeys() == null ^ this.tagKeys() == null) {
            return false;
        }
        if (other.tagKeys() != null && !other.tagKeys().equals(this.tagKeys())) {
            return false;
        }
        if (other.tagValues() == null ^ this.tagValues() == null) {
            return false;
        }
        return other.tagValues() == null || other.tagValues().equals(this.tagValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.snapshotIdentifier() != null) {
            sb.append("SnapshotIdentifier: ").append(this.snapshotIdentifier()).append(",");
        }
        if (this.snapshotType() != null) {
            sb.append("SnapshotType: ").append(this.snapshotType()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.ownerAccount() != null) {
            sb.append("OwnerAccount: ").append(this.ownerAccount()).append(",");
        }
        if (this.tagKeys() != null) {
            sb.append("TagKeys: ").append(this.tagKeys()).append(",");
        }
        if (this.tagValues() != null) {
            sb.append("TagValues: ").append(this.tagValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String snapshotIdentifier;
        private String snapshotType;
        private Date startTime;
        private Date endTime;
        private Integer maxRecords;
        private String marker;
        private String ownerAccount;
        private List<String> tagKeys = new SdkInternalList();
        private List<String> tagValues = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSnapshotsRequest model) {
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setSnapshotIdentifier(model.snapshotIdentifier);
            this.setSnapshotType(model.snapshotType);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
            this.setOwnerAccount(model.ownerAccount);
            this.setTagKeys(model.tagKeys);
            this.setTagValues(model.tagValues);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final Collection<String> getTagKeys() {
            return this.tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        @SafeVarargs
        public final void setTagKeys(String ... tagKeys) {
            if (this.tagKeys == null) {
                this.tagKeys = new SdkInternalList(tagKeys.length);
            }
            for (String e : tagKeys) {
                this.tagKeys.add(e);
            }
        }

        public final Collection<String> getTagValues() {
            return this.tagValues;
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String ... tagValues) {
            if (this.tagValues == null) {
                this.tagValues = new SdkInternalList(tagValues.length);
            }
            for (String e : tagValues) {
                this.tagValues.add(e);
            }
            return this;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @SafeVarargs
        public final void setTagValues(String ... tagValues) {
            if (this.tagValues == null) {
                this.tagValues = new SdkInternalList(tagValues.length);
            }
            for (String e : tagValues) {
                this.tagValues.add(e);
            }
        }

        public DescribeClusterSnapshotsRequest build() {
            return new DescribeClusterSnapshotsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterSnapshotsRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder snapshotIdentifier(String var1);

        public Builder snapshotType(String var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder ownerAccount(String var1);

        public Builder tagKeys(Collection<String> var1);

        public Builder tagKeys(String ... var1);

        public Builder tagValues(Collection<String> var1);

        public Builder tagValues(String ... var1);
    }
}

