/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterSecurityGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateClusterSecurityGroupRequest> {
    private final String clusterSecurityGroupName;
    private final String description;
    private final List<Tag> tags;

    private CreateClusterSecurityGroupRequest(BuilderImpl builder) {
        this.clusterSecurityGroupName = builder.clusterSecurityGroupName;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String clusterSecurityGroupName() {
        return this.clusterSecurityGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterSecurityGroupName() == null ? 0 : this.clusterSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterSecurityGroupRequest)) {
            return false;
        }
        CreateClusterSecurityGroupRequest other = (CreateClusterSecurityGroupRequest)((Object)obj);
        if (other.clusterSecurityGroupName() == null ^ this.clusterSecurityGroupName() == null) {
            return false;
        }
        if (other.clusterSecurityGroupName() != null && !other.clusterSecurityGroupName().equals(this.clusterSecurityGroupName())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterSecurityGroupName() != null) {
            sb.append("ClusterSecurityGroupName: ").append(this.clusterSecurityGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterSecurityGroupName;
        private String description;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterSecurityGroupRequest model) {
            this.setClusterSecurityGroupName(model.clusterSecurityGroupName);
            this.setDescription(model.description);
            this.setTags(model.tags);
        }

        public final String getClusterSecurityGroupName() {
            return this.clusterSecurityGroupName;
        }

        @Override
        public final Builder clusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
            return this;
        }

        public final void setClusterSecurityGroupName(String clusterSecurityGroupName) {
            this.clusterSecurityGroupName = clusterSecurityGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public CreateClusterSecurityGroupRequest build() {
            return new CreateClusterSecurityGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateClusterSecurityGroupRequest> {
        public Builder clusterSecurityGroupName(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

