/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateClusterParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateClusterParameterGroupRequest> {
    private final String parameterGroupName;
    private final String parameterGroupFamily;
    private final String description;
    private final List<Tag> tags;

    private CreateClusterParameterGroupRequest(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterGroupFamily = builder.parameterGroupFamily;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public String parameterGroupFamily() {
        return this.parameterGroupFamily;
    }

    public String description() {
        return this.description;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterGroupName() == null ? 0 : this.parameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.parameterGroupFamily() == null ? 0 : this.parameterGroupFamily().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterParameterGroupRequest)) {
            return false;
        }
        CreateClusterParameterGroupRequest other = (CreateClusterParameterGroupRequest)((Object)obj);
        if (other.parameterGroupName() == null ^ this.parameterGroupName() == null) {
            return false;
        }
        if (other.parameterGroupName() != null && !other.parameterGroupName().equals(this.parameterGroupName())) {
            return false;
        }
        if (other.parameterGroupFamily() == null ^ this.parameterGroupFamily() == null) {
            return false;
        }
        if (other.parameterGroupFamily() != null && !other.parameterGroupFamily().equals(this.parameterGroupFamily())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.parameterGroupName()).append(",");
        }
        if (this.parameterGroupFamily() != null) {
            sb.append("ParameterGroupFamily: ").append(this.parameterGroupFamily()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private String parameterGroupFamily;
        private String description;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterParameterGroupRequest model) {
            this.setParameterGroupName(model.parameterGroupName);
            this.setParameterGroupFamily(model.parameterGroupFamily);
            this.setDescription(model.description);
            this.setTags(model.tags);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterGroupFamily() {
            return this.parameterGroupFamily;
        }

        @Override
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public CreateClusterParameterGroupRequest build() {
            return new CreateClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateClusterParameterGroupRequest> {
        public Builder parameterGroupName(String var1);

        public Builder parameterGroupFamily(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

