/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroup;

public class DescribeOptionGroupsIterable
implements SdkIterable<DescribeOptionGroupsResponse> {
    private final RdsClient client;
    private final DescribeOptionGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOptionGroupsIterable(RdsClient client, DescribeOptionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOptionGroupsResponseFetcher();
    }

    public Iterator<DescribeOptionGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OptionGroup> optionGroupsList() {
        Function<DescribeOptionGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optionGroupsList() != null) {
                return response.optionGroupsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOptionGroupsResponseFetcher
    implements SyncPageFetcher<DescribeOptionGroupsResponse> {
        private DescribeOptionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeOptionGroupsResponse nextPage(DescribeOptionGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupsIterable.this.client.describeOptionGroups(DescribeOptionGroupsIterable.this.firstRequest);
            }
            return DescribeOptionGroupsIterable.this.client.describeOptionGroups((DescribeOptionGroupsRequest)((Object)DescribeOptionGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

