/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalStorageVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalStorageVolume> {
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeName").getter(AdditionalStorageVolume.getter(AdditionalStorageVolume::volumeName)).setter(AdditionalStorageVolume.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeName").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(AdditionalStorageVolume.getter(AdditionalStorageVolume::allocatedStorage)).setter(AdditionalStorageVolume.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IOPS").getter(AdditionalStorageVolume.getter(AdditionalStorageVolume::iops)).setter(AdditionalStorageVolume.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IOPS").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(AdditionalStorageVolume.getter(AdditionalStorageVolume::maxAllocatedStorage)).setter(AdditionalStorageVolume.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageThroughput").getter(AdditionalStorageVolume.getter(AdditionalStorageVolume::storageThroughput)).setter(AdditionalStorageVolume.setter(Builder::storageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(AdditionalStorageVolume.getter(AdditionalStorageVolume::storageType)).setter(AdditionalStorageVolume.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_NAME_FIELD, ALLOCATED_STORAGE_FIELD, IOPS_FIELD, MAX_ALLOCATED_STORAGE_FIELD, STORAGE_THROUGHPUT_FIELD, STORAGE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AdditionalStorageVolume.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeName;
    private final Integer allocatedStorage;
    private final Integer iops;
    private final Integer maxAllocatedStorage;
    private final Integer storageThroughput;
    private final String storageType;

    private AdditionalStorageVolume(BuilderImpl builder) {
        this.volumeName = builder.volumeName;
        this.allocatedStorage = builder.allocatedStorage;
        this.iops = builder.iops;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.storageThroughput = builder.storageThroughput;
        this.storageType = builder.storageType;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final Integer storageThroughput() {
        return this.storageThroughput;
    }

    public final String storageType() {
        return this.storageType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalStorageVolume)) {
            return false;
        }
        AdditionalStorageVolume other = (AdditionalStorageVolume)obj;
        return Objects.equals(this.volumeName(), other.volumeName()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.storageThroughput(), other.storageThroughput()) && Objects.equals(this.storageType(), other.storageType());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalStorageVolume").add("VolumeName", (Object)this.volumeName()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("IOPS", (Object)this.iops()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("StorageThroughput", (Object)this.storageThroughput()).add("StorageType", (Object)this.storageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "IOPS": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "StorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.storageThroughput()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeName", VOLUME_NAME_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("IOPS", IOPS_FIELD);
        map.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdditionalStorageVolume, T> g) {
        return obj -> g.apply((AdditionalStorageVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeName;
        private Integer allocatedStorage;
        private Integer iops;
        private Integer maxAllocatedStorage;
        private Integer storageThroughput;
        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalStorageVolume model) {
            this.volumeName(model.volumeName);
            this.allocatedStorage(model.allocatedStorage);
            this.iops(model.iops);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.storageThroughput(model.storageThroughput);
            this.storageType(model.storageType);
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Integer getStorageThroughput() {
            return this.storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public AdditionalStorageVolume build() {
            return new AdditionalStorageVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalStorageVolume> {
        public Builder volumeName(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder iops(Integer var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder storageThroughput(Integer var1);

        public Builder storageType(String var1);
    }
}

