/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceType {
    DB_INSTANCE("db-instance"),
    DB_PARAMETER_GROUP("db-parameter-group"),
    DB_SECURITY_GROUP("db-security-group"),
    DB_SNAPSHOT("db-snapshot"),
    DB_CLUSTER("db-cluster"),
    DB_CLUSTER_SNAPSHOT("db-cluster-snapshot"),
    CUSTOM_ENGINE_VERSION("custom-engine-version"),
    DB_PROXY("db-proxy"),
    BLUE_GREEN_DEPLOYMENT("blue-green-deployment"),
    DB_SHARD_GROUP("db-shard-group"),
    ZERO_ETL("zero-etl"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceType> VALUE_MAP;
    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceType> knownValues() {
        EnumSet<SourceType> knownValues = EnumSet.allOf(SourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceType.class, SourceType::toString);
    }
}

