/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.AuthScheme;
import software.amazon.awssdk.services.rds.model.ClientPasswordAuthType;
import software.amazon.awssdk.services.rds.model.IAMAuthMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserAuthConfigInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserAuthConfigInfo> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UserAuthConfigInfo.getter(UserAuthConfigInfo::description)).setter(UserAuthConfigInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(UserAuthConfigInfo.getter(UserAuthConfigInfo::userName)).setter(UserAuthConfigInfo.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> AUTH_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthScheme").getter(UserAuthConfigInfo.getter(UserAuthConfigInfo::authSchemeAsString)).setter(UserAuthConfigInfo.setter(Builder::authScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthScheme").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(UserAuthConfigInfo.getter(UserAuthConfigInfo::secretArn)).setter(UserAuthConfigInfo.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> IAM_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMAuth").getter(UserAuthConfigInfo.getter(UserAuthConfigInfo::iamAuthAsString)).setter(UserAuthConfigInfo.setter(Builder::iamAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMAuth").build()}).build();
    private static final SdkField<String> CLIENT_PASSWORD_AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientPasswordAuthType").getter(UserAuthConfigInfo.getter(UserAuthConfigInfo::clientPasswordAuthTypeAsString)).setter(UserAuthConfigInfo.setter(Builder::clientPasswordAuthType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientPasswordAuthType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, USER_NAME_FIELD, AUTH_SCHEME_FIELD, SECRET_ARN_FIELD, IAM_AUTH_FIELD, CLIENT_PASSWORD_AUTH_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UserAuthConfigInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String userName;
    private final String authScheme;
    private final String secretArn;
    private final String iamAuth;
    private final String clientPasswordAuthType;

    private UserAuthConfigInfo(BuilderImpl builder) {
        this.description = builder.description;
        this.userName = builder.userName;
        this.authScheme = builder.authScheme;
        this.secretArn = builder.secretArn;
        this.iamAuth = builder.iamAuth;
        this.clientPasswordAuthType = builder.clientPasswordAuthType;
    }

    public final String description() {
        return this.description;
    }

    public final String userName() {
        return this.userName;
    }

    public final AuthScheme authScheme() {
        return AuthScheme.fromValue(this.authScheme);
    }

    public final String authSchemeAsString() {
        return this.authScheme;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final IAMAuthMode iamAuth() {
        return IAMAuthMode.fromValue(this.iamAuth);
    }

    public final String iamAuthAsString() {
        return this.iamAuth;
    }

    public final ClientPasswordAuthType clientPasswordAuthType() {
        return ClientPasswordAuthType.fromValue(this.clientPasswordAuthType);
    }

    public final String clientPasswordAuthTypeAsString() {
        return this.clientPasswordAuthType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamAuthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientPasswordAuthTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAuthConfigInfo)) {
            return false;
        }
        UserAuthConfigInfo other = (UserAuthConfigInfo)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.authSchemeAsString(), other.authSchemeAsString()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.iamAuthAsString(), other.iamAuthAsString()) && Objects.equals(this.clientPasswordAuthTypeAsString(), other.clientPasswordAuthTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UserAuthConfigInfo").add("Description", (Object)this.description()).add("UserName", (Object)this.userName()).add("AuthScheme", (Object)this.authSchemeAsString()).add("SecretArn", (Object)this.secretArn()).add("IAMAuth", (Object)this.iamAuthAsString()).add("ClientPasswordAuthType", (Object)this.clientPasswordAuthTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "AuthScheme": {
                return Optional.ofNullable(clazz.cast(this.authSchemeAsString()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "IAMAuth": {
                return Optional.ofNullable(clazz.cast(this.iamAuthAsString()));
            }
            case "ClientPasswordAuthType": {
                return Optional.ofNullable(clazz.cast(this.clientPasswordAuthTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        map.put("AuthScheme", AUTH_SCHEME_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("IAMAuth", IAM_AUTH_FIELD);
        map.put("ClientPasswordAuthType", CLIENT_PASSWORD_AUTH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserAuthConfigInfo, T> g) {
        return obj -> g.apply((UserAuthConfigInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String userName;
        private String authScheme;
        private String secretArn;
        private String iamAuth;
        private String clientPasswordAuthType;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAuthConfigInfo model) {
            this.description(model.description);
            this.userName(model.userName);
            this.authScheme(model.authScheme);
            this.secretArn(model.secretArn);
            this.iamAuth(model.iamAuth);
            this.clientPasswordAuthType(model.clientPasswordAuthType);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getAuthScheme() {
            return this.authScheme;
        }

        public final void setAuthScheme(String authScheme) {
            this.authScheme = authScheme;
        }

        @Override
        public final Builder authScheme(String authScheme) {
            this.authScheme = authScheme;
            return this;
        }

        @Override
        public final Builder authScheme(AuthScheme authScheme) {
            this.authScheme(authScheme == null ? null : authScheme.toString());
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getIamAuth() {
            return this.iamAuth;
        }

        public final void setIamAuth(String iamAuth) {
            this.iamAuth = iamAuth;
        }

        @Override
        public final Builder iamAuth(String iamAuth) {
            this.iamAuth = iamAuth;
            return this;
        }

        @Override
        public final Builder iamAuth(IAMAuthMode iamAuth) {
            this.iamAuth(iamAuth == null ? null : iamAuth.toString());
            return this;
        }

        public final String getClientPasswordAuthType() {
            return this.clientPasswordAuthType;
        }

        public final void setClientPasswordAuthType(String clientPasswordAuthType) {
            this.clientPasswordAuthType = clientPasswordAuthType;
        }

        @Override
        public final Builder clientPasswordAuthType(String clientPasswordAuthType) {
            this.clientPasswordAuthType = clientPasswordAuthType;
            return this;
        }

        @Override
        public final Builder clientPasswordAuthType(ClientPasswordAuthType clientPasswordAuthType) {
            this.clientPasswordAuthType(clientPasswordAuthType == null ? null : clientPasswordAuthType.toString());
            return this;
        }

        public UserAuthConfigInfo build() {
            return new UserAuthConfigInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserAuthConfigInfo> {
        public Builder description(String var1);

        public Builder userName(String var1);

        public Builder authScheme(String var1);

        public Builder authScheme(AuthScheme var1);

        public Builder secretArn(String var1);

        public Builder iamAuth(String var1);

        public Builder iamAuth(IAMAuthMode var1);

        public Builder clientPasswordAuthType(String var1);

        public Builder clientPasswordAuthType(ClientPasswordAuthType var1);
    }
}

