/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTask;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentTaskListCopier;
import software.amazon.awssdk.services.rds.model.SwitchoverDetail;
import software.amazon.awssdk.services.rds.model.SwitchoverDetailListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlueGreenDeployment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlueGreenDeployment> {
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueGreenDeploymentIdentifier").getter(BlueGreenDeployment.getter(BlueGreenDeployment::blueGreenDeploymentIdentifier)).setter(BlueGreenDeployment.setter(Builder::blueGreenDeploymentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentIdentifier").build()}).build();
    private static final SdkField<String> BLUE_GREEN_DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlueGreenDeploymentName").getter(BlueGreenDeployment.getter(BlueGreenDeployment::blueGreenDeploymentName)).setter(BlueGreenDeployment.setter(Builder::blueGreenDeploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenDeploymentName").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(BlueGreenDeployment.getter(BlueGreenDeployment::source)).setter(BlueGreenDeployment.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(BlueGreenDeployment.getter(BlueGreenDeployment::target)).setter(BlueGreenDeployment.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<List<SwitchoverDetail>> SWITCHOVER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SwitchoverDetails").getter(BlueGreenDeployment.getter(BlueGreenDeployment::switchoverDetails)).setter(BlueGreenDeployment.setter(Builder::switchoverDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SwitchoverDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SwitchoverDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BlueGreenDeploymentTask>> TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tasks").getter(BlueGreenDeployment.getter(BlueGreenDeployment::tasks)).setter(BlueGreenDeployment.setter(Builder::tasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BlueGreenDeploymentTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(BlueGreenDeployment.getter(BlueGreenDeployment::status)).setter(BlueGreenDeployment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(BlueGreenDeployment.getter(BlueGreenDeployment::statusDetails)).setter(BlueGreenDeployment.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(BlueGreenDeployment.getter(BlueGreenDeployment::createTime)).setter(BlueGreenDeployment.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<Instant> DELETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeleteTime").getter(BlueGreenDeployment.getter(BlueGreenDeployment::deleteTime)).setter(BlueGreenDeployment.setter(Builder::deleteTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteTime").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(BlueGreenDeployment.getter(BlueGreenDeployment::tagList)).setter(BlueGreenDeployment.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD, BLUE_GREEN_DEPLOYMENT_NAME_FIELD, SOURCE_FIELD, TARGET_FIELD, SWITCHOVER_DETAILS_FIELD, TASKS_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, CREATE_TIME_FIELD, DELETE_TIME_FIELD, TAG_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BlueGreenDeployment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String blueGreenDeploymentIdentifier;
    private final String blueGreenDeploymentName;
    private final String source;
    private final String target;
    private final List<SwitchoverDetail> switchoverDetails;
    private final List<BlueGreenDeploymentTask> tasks;
    private final String status;
    private final String statusDetails;
    private final Instant createTime;
    private final Instant deleteTime;
    private final List<Tag> tagList;

    private BlueGreenDeployment(BuilderImpl builder) {
        this.blueGreenDeploymentIdentifier = builder.blueGreenDeploymentIdentifier;
        this.blueGreenDeploymentName = builder.blueGreenDeploymentName;
        this.source = builder.source;
        this.target = builder.target;
        this.switchoverDetails = builder.switchoverDetails;
        this.tasks = builder.tasks;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.createTime = builder.createTime;
        this.deleteTime = builder.deleteTime;
        this.tagList = builder.tagList;
    }

    public final String blueGreenDeploymentIdentifier() {
        return this.blueGreenDeploymentIdentifier;
    }

    public final String blueGreenDeploymentName() {
        return this.blueGreenDeploymentName;
    }

    public final String source() {
        return this.source;
    }

    public final String target() {
        return this.target;
    }

    public final boolean hasSwitchoverDetails() {
        return this.switchoverDetails != null && !(this.switchoverDetails instanceof SdkAutoConstructList);
    }

    public final List<SwitchoverDetail> switchoverDetails() {
        return this.switchoverDetails;
    }

    public final boolean hasTasks() {
        return this.tasks != null && !(this.tasks instanceof SdkAutoConstructList);
    }

    public final List<BlueGreenDeploymentTask> tasks() {
        return this.tasks;
    }

    public final String status() {
        return this.status;
    }

    public final String statusDetails() {
        return this.statusDetails;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant deleteTime() {
        return this.deleteTime;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSwitchoverDetails() ? this.switchoverDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTasks() ? this.tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueGreenDeployment)) {
            return false;
        }
        BlueGreenDeployment other = (BlueGreenDeployment)obj;
        return Objects.equals(this.blueGreenDeploymentIdentifier(), other.blueGreenDeploymentIdentifier()) && Objects.equals(this.blueGreenDeploymentName(), other.blueGreenDeploymentName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && this.hasSwitchoverDetails() == other.hasSwitchoverDetails() && Objects.equals(this.switchoverDetails(), other.switchoverDetails()) && this.hasTasks() == other.hasTasks() && Objects.equals(this.tasks(), other.tasks()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.deleteTime(), other.deleteTime()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public final String toString() {
        return ToString.builder((String)"BlueGreenDeployment").add("BlueGreenDeploymentIdentifier", (Object)this.blueGreenDeploymentIdentifier()).add("BlueGreenDeploymentName", (Object)this.blueGreenDeploymentName()).add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("SwitchoverDetails", this.hasSwitchoverDetails() ? this.switchoverDetails() : null).add("Tasks", this.hasTasks() ? this.tasks() : null).add("Status", (Object)this.status()).add("StatusDetails", (Object)this.statusDetails()).add("CreateTime", (Object)this.createTime()).add("DeleteTime", (Object)this.deleteTime()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlueGreenDeploymentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeploymentIdentifier()));
            }
            case "BlueGreenDeploymentName": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeploymentName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "SwitchoverDetails": {
                return Optional.ofNullable(clazz.cast(this.switchoverDetails()));
            }
            case "Tasks": {
                return Optional.ofNullable(clazz.cast(this.tasks()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "DeleteTime": {
                return Optional.ofNullable(clazz.cast(this.deleteTime()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BlueGreenDeploymentIdentifier", BLUE_GREEN_DEPLOYMENT_IDENTIFIER_FIELD);
        map.put("BlueGreenDeploymentName", BLUE_GREEN_DEPLOYMENT_NAME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("SwitchoverDetails", SWITCHOVER_DETAILS_FIELD);
        map.put("Tasks", TASKS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusDetails", STATUS_DETAILS_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("DeleteTime", DELETE_TIME_FIELD);
        map.put("TagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlueGreenDeployment, T> g) {
        return obj -> g.apply((BlueGreenDeployment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String blueGreenDeploymentIdentifier;
        private String blueGreenDeploymentName;
        private String source;
        private String target;
        private List<SwitchoverDetail> switchoverDetails = DefaultSdkAutoConstructList.getInstance();
        private List<BlueGreenDeploymentTask> tasks = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusDetails;
        private Instant createTime;
        private Instant deleteTime;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BlueGreenDeployment model) {
            this.blueGreenDeploymentIdentifier(model.blueGreenDeploymentIdentifier);
            this.blueGreenDeploymentName(model.blueGreenDeploymentName);
            this.source(model.source);
            this.target(model.target);
            this.switchoverDetails(model.switchoverDetails);
            this.tasks(model.tasks);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.createTime(model.createTime);
            this.deleteTime(model.deleteTime);
            this.tagList(model.tagList);
        }

        public final String getBlueGreenDeploymentIdentifier() {
            return this.blueGreenDeploymentIdentifier;
        }

        public final void setBlueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
        }

        @Override
        public final Builder blueGreenDeploymentIdentifier(String blueGreenDeploymentIdentifier) {
            this.blueGreenDeploymentIdentifier = blueGreenDeploymentIdentifier;
            return this;
        }

        public final String getBlueGreenDeploymentName() {
            return this.blueGreenDeploymentName;
        }

        public final void setBlueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
        }

        @Override
        public final Builder blueGreenDeploymentName(String blueGreenDeploymentName) {
            this.blueGreenDeploymentName = blueGreenDeploymentName;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final List<SwitchoverDetail.Builder> getSwitchoverDetails() {
            List<SwitchoverDetail.Builder> result = SwitchoverDetailListCopier.copyToBuilder(this.switchoverDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSwitchoverDetails(Collection<SwitchoverDetail.BuilderImpl> switchoverDetails) {
            this.switchoverDetails = SwitchoverDetailListCopier.copyFromBuilder(switchoverDetails);
        }

        @Override
        public final Builder switchoverDetails(Collection<SwitchoverDetail> switchoverDetails) {
            this.switchoverDetails = SwitchoverDetailListCopier.copy(switchoverDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder switchoverDetails(SwitchoverDetail ... switchoverDetails) {
            this.switchoverDetails(Arrays.asList(switchoverDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder switchoverDetails(Consumer<SwitchoverDetail.Builder> ... switchoverDetails) {
            this.switchoverDetails(Stream.of(switchoverDetails).map(c -> (SwitchoverDetail)((SwitchoverDetail.Builder)SwitchoverDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BlueGreenDeploymentTask.Builder> getTasks() {
            List<BlueGreenDeploymentTask.Builder> result = BlueGreenDeploymentTaskListCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<BlueGreenDeploymentTask.BuilderImpl> tasks) {
            this.tasks = BlueGreenDeploymentTaskListCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<BlueGreenDeploymentTask> tasks) {
            this.tasks = BlueGreenDeploymentTaskListCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(BlueGreenDeploymentTask ... tasks) {
            this.tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<BlueGreenDeploymentTask.Builder> ... tasks) {
            this.tasks(Stream.of(tasks).map(c -> (BlueGreenDeploymentTask)((BlueGreenDeploymentTask.Builder)BlueGreenDeploymentTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getDeleteTime() {
            return this.deleteTime;
        }

        public final void setDeleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
        }

        @Override
        public final Builder deleteTime(Instant deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BlueGreenDeployment build() {
            return new BlueGreenDeployment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlueGreenDeployment> {
        public Builder blueGreenDeploymentIdentifier(String var1);

        public Builder blueGreenDeploymentName(String var1);

        public Builder source(String var1);

        public Builder target(String var1);

        public Builder switchoverDetails(Collection<SwitchoverDetail> var1);

        public Builder switchoverDetails(SwitchoverDetail ... var1);

        public Builder switchoverDetails(Consumer<SwitchoverDetail.Builder> ... var1);

        public Builder tasks(Collection<BlueGreenDeploymentTask> var1);

        public Builder tasks(BlueGreenDeploymentTask ... var1);

        public Builder tasks(Consumer<BlueGreenDeploymentTask.Builder> ... var1);

        public Builder status(String var1);

        public Builder statusDetails(String var1);

        public Builder createTime(Instant var1);

        public Builder deleteTime(Instant var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);
    }
}

