/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBClusterBacktrack
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBClusterBacktrack> {
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(DBClusterBacktrack.getter(DBClusterBacktrack::dbClusterIdentifier)).setter(DBClusterBacktrack.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> BACKTRACK_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BacktrackIdentifier").getter(DBClusterBacktrack.getter(DBClusterBacktrack::backtrackIdentifier)).setter(DBClusterBacktrack.setter(Builder::backtrackIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackIdentifier").build()}).build();
    private static final SdkField<Instant> BACKTRACK_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackTo").getter(DBClusterBacktrack.getter(DBClusterBacktrack::backtrackTo)).setter(DBClusterBacktrack.setter(Builder::backtrackTo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackTo").build()}).build();
    private static final SdkField<Instant> BACKTRACKED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackedFrom").getter(DBClusterBacktrack.getter(DBClusterBacktrack::backtrackedFrom)).setter(DBClusterBacktrack.setter(Builder::backtrackedFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackedFrom").build()}).build();
    private static final SdkField<Instant> BACKTRACK_REQUEST_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BacktrackRequestCreationTime").getter(DBClusterBacktrack.getter(DBClusterBacktrack::backtrackRequestCreationTime)).setter(DBClusterBacktrack.setter(Builder::backtrackRequestCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackRequestCreationTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBClusterBacktrack.getter(DBClusterBacktrack::status)).setter(DBClusterBacktrack.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_IDENTIFIER_FIELD, BACKTRACK_IDENTIFIER_FIELD, BACKTRACK_TO_FIELD, BACKTRACKED_FROM_FIELD, BACKTRACK_REQUEST_CREATION_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DBClusterBacktrack.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbClusterIdentifier;
    private final String backtrackIdentifier;
    private final Instant backtrackTo;
    private final Instant backtrackedFrom;
    private final Instant backtrackRequestCreationTime;
    private final String status;

    private DBClusterBacktrack(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.backtrackIdentifier = builder.backtrackIdentifier;
        this.backtrackTo = builder.backtrackTo;
        this.backtrackedFrom = builder.backtrackedFrom;
        this.backtrackRequestCreationTime = builder.backtrackRequestCreationTime;
        this.status = builder.status;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String backtrackIdentifier() {
        return this.backtrackIdentifier;
    }

    public final Instant backtrackTo() {
        return this.backtrackTo;
    }

    public final Instant backtrackedFrom() {
        return this.backtrackedFrom;
    }

    public final Instant backtrackRequestCreationTime() {
        return this.backtrackRequestCreationTime;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackRequestCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBClusterBacktrack)) {
            return false;
        }
        DBClusterBacktrack other = (DBClusterBacktrack)obj;
        return Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.backtrackIdentifier(), other.backtrackIdentifier()) && Objects.equals(this.backtrackTo(), other.backtrackTo()) && Objects.equals(this.backtrackedFrom(), other.backtrackedFrom()) && Objects.equals(this.backtrackRequestCreationTime(), other.backtrackRequestCreationTime()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DBClusterBacktrack").add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("BacktrackIdentifier", (Object)this.backtrackIdentifier()).add("BacktrackTo", (Object)this.backtrackTo()).add("BacktrackedFrom", (Object)this.backtrackedFrom()).add("BacktrackRequestCreationTime", (Object)this.backtrackRequestCreationTime()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "BacktrackIdentifier": {
                return Optional.ofNullable(clazz.cast(this.backtrackIdentifier()));
            }
            case "BacktrackTo": {
                return Optional.ofNullable(clazz.cast(this.backtrackTo()));
            }
            case "BacktrackedFrom": {
                return Optional.ofNullable(clazz.cast(this.backtrackedFrom()));
            }
            case "BacktrackRequestCreationTime": {
                return Optional.ofNullable(clazz.cast(this.backtrackRequestCreationTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBClusterIdentifier", DB_CLUSTER_IDENTIFIER_FIELD);
        map.put("BacktrackIdentifier", BACKTRACK_IDENTIFIER_FIELD);
        map.put("BacktrackTo", BACKTRACK_TO_FIELD);
        map.put("BacktrackedFrom", BACKTRACKED_FROM_FIELD);
        map.put("BacktrackRequestCreationTime", BACKTRACK_REQUEST_CREATION_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DBClusterBacktrack, T> g) {
        return obj -> g.apply((DBClusterBacktrack)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String backtrackIdentifier;
        private Instant backtrackTo;
        private Instant backtrackedFrom;
        private Instant backtrackRequestCreationTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DBClusterBacktrack model) {
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.backtrackIdentifier(model.backtrackIdentifier);
            this.backtrackTo(model.backtrackTo);
            this.backtrackedFrom(model.backtrackedFrom);
            this.backtrackRequestCreationTime(model.backtrackRequestCreationTime);
            this.status(model.status);
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getBacktrackIdentifier() {
            return this.backtrackIdentifier;
        }

        public final void setBacktrackIdentifier(String backtrackIdentifier) {
            this.backtrackIdentifier = backtrackIdentifier;
        }

        @Override
        public final Builder backtrackIdentifier(String backtrackIdentifier) {
            this.backtrackIdentifier = backtrackIdentifier;
            return this;
        }

        public final Instant getBacktrackTo() {
            return this.backtrackTo;
        }

        public final void setBacktrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
        }

        @Override
        public final Builder backtrackTo(Instant backtrackTo) {
            this.backtrackTo = backtrackTo;
            return this;
        }

        public final Instant getBacktrackedFrom() {
            return this.backtrackedFrom;
        }

        public final void setBacktrackedFrom(Instant backtrackedFrom) {
            this.backtrackedFrom = backtrackedFrom;
        }

        @Override
        public final Builder backtrackedFrom(Instant backtrackedFrom) {
            this.backtrackedFrom = backtrackedFrom;
            return this;
        }

        public final Instant getBacktrackRequestCreationTime() {
            return this.backtrackRequestCreationTime;
        }

        public final void setBacktrackRequestCreationTime(Instant backtrackRequestCreationTime) {
            this.backtrackRequestCreationTime = backtrackRequestCreationTime;
        }

        @Override
        public final Builder backtrackRequestCreationTime(Instant backtrackRequestCreationTime) {
            this.backtrackRequestCreationTime = backtrackRequestCreationTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public DBClusterBacktrack build() {
            return new DBClusterBacktrack(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBClusterBacktrack> {
        public Builder dbClusterIdentifier(String var1);

        public Builder backtrackIdentifier(String var1);

        public Builder backtrackTo(Instant var1);

        public Builder backtrackedFrom(Instant var1);

        public Builder backtrackRequestCreationTime(Instant var1);

        public Builder status(String var1);
    }
}

