/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainMembership
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainMembership> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DomainMembership.getter(DomainMembership::domain)).setter(DomainMembership.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DomainMembership.getter(DomainMembership::status)).setter(DomainMembership.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FQDN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FQDN").getter(DomainMembership.getter(DomainMembership::fqdn)).setter(DomainMembership.setter(Builder::fqdn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FQDN").build()}).build();
    private static final SdkField<String> IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IAMRoleName").getter(DomainMembership.getter(DomainMembership::iamRoleName)).setter(DomainMembership.setter(Builder::iamRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMRoleName").build()}).build();
    private static final SdkField<String> OU_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OU").getter(DomainMembership.getter(DomainMembership::ou)).setter(DomainMembership.setter(Builder::ou)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OU").build()}).build();
    private static final SdkField<String> AUTH_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthSecretArn").getter(DomainMembership.getter(DomainMembership::authSecretArn)).setter(DomainMembership.setter(Builder::authSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthSecretArn").build()}).build();
    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DnsIps").getter(DomainMembership.getter(DomainMembership::dnsIps)).setter(DomainMembership.setter(Builder::dnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD, FQDN_FIELD, IAM_ROLE_NAME_FIELD, OU_FIELD, AUTH_SECRET_ARN_FIELD, DNS_IPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Domain", DOMAIN_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("FQDN", FQDN_FIELD);
            this.put("IAMRoleName", IAM_ROLE_NAME_FIELD);
            this.put("OU", OU_FIELD);
            this.put("AuthSecretArn", AUTH_SECRET_ARN_FIELD);
            this.put("DnsIps", DNS_IPS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String status;
    private final String fqdn;
    private final String iamRoleName;
    private final String ou;
    private final String authSecretArn;
    private final List<String> dnsIps;

    private DomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
        this.ou = builder.ou;
        this.authSecretArn = builder.authSecretArn;
        this.dnsIps = builder.dnsIps;
    }

    public final String domain() {
        return this.domain;
    }

    public final String status() {
        return this.status;
    }

    public final String fqdn() {
        return this.fqdn;
    }

    public final String iamRoleName() {
        return this.iamRoleName;
    }

    public final String ou() {
        return this.ou;
    }

    public final String authSecretArn() {
        return this.authSecretArn;
    }

    public final boolean hasDnsIps() {
        return this.dnsIps != null && !(this.dnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> dnsIps() {
        return this.dnsIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ou());
        hashCode = 31 * hashCode + Objects.hashCode(this.authSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsIps() ? this.dnsIps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainMembership)) {
            return false;
        }
        DomainMembership other = (DomainMembership)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.fqdn(), other.fqdn()) && Objects.equals(this.iamRoleName(), other.iamRoleName()) && Objects.equals(this.ou(), other.ou()) && Objects.equals(this.authSecretArn(), other.authSecretArn()) && this.hasDnsIps() == other.hasDnsIps() && Objects.equals(this.dnsIps(), other.dnsIps());
    }

    public final String toString() {
        return ToString.builder((String)"DomainMembership").add("Domain", (Object)this.domain()).add("Status", (Object)this.status()).add("FQDN", (Object)this.fqdn()).add("IAMRoleName", (Object)this.iamRoleName()).add("OU", (Object)this.ou()).add("AuthSecretArn", (Object)this.authSecretArn()).add("DnsIps", this.hasDnsIps() ? this.dnsIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "FQDN": {
                return Optional.ofNullable(clazz.cast(this.fqdn()));
            }
            case "IAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.iamRoleName()));
            }
            case "OU": {
                return Optional.ofNullable(clazz.cast(this.ou()));
            }
            case "AuthSecretArn": {
                return Optional.ofNullable(clazz.cast(this.authSecretArn()));
            }
            case "DnsIps": {
                return Optional.ofNullable(clazz.cast(this.dnsIps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DomainMembership, T> g) {
        return obj -> g.apply((DomainMembership)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String status;
        private String fqdn;
        private String iamRoleName;
        private String ou;
        private String authSecretArn;
        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainMembership model) {
            this.domain(model.domain);
            this.status(model.status);
            this.fqdn(model.fqdn);
            this.iamRoleName(model.iamRoleName);
            this.ou(model.ou);
            this.authSecretArn(model.authSecretArn);
            this.dnsIps(model.dnsIps);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFqdn() {
            return this.fqdn;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        @Override
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final String getIamRoleName() {
            return this.iamRoleName;
        }

        public final void setIamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        @Override
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        public final String getOu() {
            return this.ou;
        }

        public final void setOu(String ou) {
            this.ou = ou;
        }

        @Override
        public final Builder ou(String ou) {
            this.ou = ou;
            return this;
        }

        public final String getAuthSecretArn() {
            return this.authSecretArn;
        }

        public final void setAuthSecretArn(String authSecretArn) {
            this.authSecretArn = authSecretArn;
        }

        @Override
        public final Builder authSecretArn(String authSecretArn) {
            this.authSecretArn = authSecretArn;
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (this.dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = StringListCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = StringListCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String ... dnsIps) {
            this.dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        public DomainMembership build() {
            return new DomainMembership(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainMembership> {
        public Builder domain(String var1);

        public Builder status(String var1);

        public Builder fqdn(String var1);

        public Builder iamRoleName(String var1);

        public Builder ou(String var1);

        public Builder authSecretArn(String var1);

        public Builder dnsIps(Collection<String> var1);

        public Builder dnsIps(String ... var1);
    }
}

