/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.UserAuthConfig;
import software.amazon.awssdk.services.rds.model.UserAuthConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbProxyRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbProxyRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::dbProxyName)).setter(ModifyDbProxyRequest.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> NEW_DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewDBProxyName").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::newDBProxyName)).setter(ModifyDbProxyRequest.setter(Builder::newDBProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBProxyName").build()}).build();
    private static final SdkField<List<UserAuthConfig>> AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Auth").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::auth)).setter(ModifyDbProxyRequest.setter(Builder::auth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Auth").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserAuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REQUIRE_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RequireTLS").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::requireTLS)).setter(ModifyDbProxyRequest.setter(Builder::requireTLS)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireTLS").build()}).build();
    private static final SdkField<Integer> IDLE_CLIENT_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IdleClientTimeout").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::idleClientTimeout)).setter(ModifyDbProxyRequest.setter(Builder::idleClientTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleClientTimeout").build()}).build();
    private static final SdkField<Boolean> DEBUG_LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DebugLogging").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::debugLogging)).setter(ModifyDbProxyRequest.setter(Builder::debugLogging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DebugLogging").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::roleArn)).setter(ModifyDbProxyRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(ModifyDbProxyRequest.getter(ModifyDbProxyRequest::securityGroups)).setter(ModifyDbProxyRequest.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD, NEW_DB_PROXY_NAME_FIELD, AUTH_FIELD, REQUIRE_TLS_FIELD, IDLE_CLIENT_TIMEOUT_FIELD, DEBUG_LOGGING_FIELD, ROLE_ARN_FIELD, SECURITY_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBProxyName", DB_PROXY_NAME_FIELD);
            this.put("NewDBProxyName", NEW_DB_PROXY_NAME_FIELD);
            this.put("Auth", AUTH_FIELD);
            this.put("RequireTLS", REQUIRE_TLS_FIELD);
            this.put("IdleClientTimeout", IDLE_CLIENT_TIMEOUT_FIELD);
            this.put("DebugLogging", DEBUG_LOGGING_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        }
    });
    private final String dbProxyName;
    private final String newDBProxyName;
    private final List<UserAuthConfig> auth;
    private final Boolean requireTLS;
    private final Integer idleClientTimeout;
    private final Boolean debugLogging;
    private final String roleArn;
    private final List<String> securityGroups;

    private ModifyDbProxyRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.newDBProxyName = builder.newDBProxyName;
        this.auth = builder.auth;
        this.requireTLS = builder.requireTLS;
        this.idleClientTimeout = builder.idleClientTimeout;
        this.debugLogging = builder.debugLogging;
        this.roleArn = builder.roleArn;
        this.securityGroups = builder.securityGroups;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final String newDBProxyName() {
        return this.newDBProxyName;
    }

    public final boolean hasAuth() {
        return this.auth != null && !(this.auth instanceof SdkAutoConstructList);
    }

    public final List<UserAuthConfig> auth() {
        return this.auth;
    }

    public final Boolean requireTLS() {
        return this.requireTLS;
    }

    public final Integer idleClientTimeout() {
        return this.idleClientTimeout;
    }

    public final Boolean debugLogging() {
        return this.debugLogging;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDBProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuth() ? this.auth() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requireTLS());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleClientTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.debugLogging());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyRequest)) {
            return false;
        }
        ModifyDbProxyRequest other = (ModifyDbProxyRequest)((Object)obj);
        return Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.newDBProxyName(), other.newDBProxyName()) && this.hasAuth() == other.hasAuth() && Objects.equals(this.auth(), other.auth()) && Objects.equals(this.requireTLS(), other.requireTLS()) && Objects.equals(this.idleClientTimeout(), other.idleClientTimeout()) && Objects.equals(this.debugLogging(), other.debugLogging()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbProxyRequest").add("DBProxyName", (Object)this.dbProxyName()).add("NewDBProxyName", (Object)this.newDBProxyName()).add("Auth", this.hasAuth() ? this.auth() : null).add("RequireTLS", (Object)this.requireTLS()).add("IdleClientTimeout", (Object)this.idleClientTimeout()).add("DebugLogging", (Object)this.debugLogging()).add("RoleArn", (Object)this.roleArn()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "NewDBProxyName": {
                return Optional.ofNullable(clazz.cast(this.newDBProxyName()));
            }
            case "Auth": {
                return Optional.ofNullable(clazz.cast(this.auth()));
            }
            case "RequireTLS": {
                return Optional.ofNullable(clazz.cast(this.requireTLS()));
            }
            case "IdleClientTimeout": {
                return Optional.ofNullable(clazz.cast(this.idleClientTimeout()));
            }
            case "DebugLogging": {
                return Optional.ofNullable(clazz.cast(this.debugLogging()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyRequest, T> g) {
        return obj -> g.apply((ModifyDbProxyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbProxyName;
        private String newDBProxyName;
        private List<UserAuthConfig> auth = DefaultSdkAutoConstructList.getInstance();
        private Boolean requireTLS;
        private Integer idleClientTimeout;
        private Boolean debugLogging;
        private String roleArn;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyRequest model) {
            super(model);
            this.dbProxyName(model.dbProxyName);
            this.newDBProxyName(model.newDBProxyName);
            this.auth(model.auth);
            this.requireTLS(model.requireTLS);
            this.idleClientTimeout(model.idleClientTimeout);
            this.debugLogging(model.debugLogging);
            this.roleArn(model.roleArn);
            this.securityGroups(model.securityGroups);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getNewDBProxyName() {
            return this.newDBProxyName;
        }

        public final void setNewDBProxyName(String newDBProxyName) {
            this.newDBProxyName = newDBProxyName;
        }

        @Override
        public final Builder newDBProxyName(String newDBProxyName) {
            this.newDBProxyName = newDBProxyName;
            return this;
        }

        public final List<UserAuthConfig.Builder> getAuth() {
            List<UserAuthConfig.Builder> result = UserAuthConfigListCopier.copyToBuilder(this.auth);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuth(Collection<UserAuthConfig.BuilderImpl> auth) {
            this.auth = UserAuthConfigListCopier.copyFromBuilder(auth);
        }

        @Override
        public final Builder auth(Collection<UserAuthConfig> auth) {
            this.auth = UserAuthConfigListCopier.copy(auth);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(UserAuthConfig ... auth) {
            this.auth(Arrays.asList(auth));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auth(Consumer<UserAuthConfig.Builder> ... auth) {
            this.auth(Stream.of(auth).map(c -> (UserAuthConfig)((UserAuthConfig.Builder)UserAuthConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getRequireTLS() {
            return this.requireTLS;
        }

        public final void setRequireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
        }

        @Override
        public final Builder requireTLS(Boolean requireTLS) {
            this.requireTLS = requireTLS;
            return this;
        }

        public final Integer getIdleClientTimeout() {
            return this.idleClientTimeout;
        }

        public final void setIdleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
        }

        @Override
        public final Builder idleClientTimeout(Integer idleClientTimeout) {
            this.idleClientTimeout = idleClientTimeout;
            return this;
        }

        public final Boolean getDebugLogging() {
            return this.debugLogging;
        }

        public final void setDebugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
        }

        @Override
        public final Builder debugLogging(Boolean debugLogging) {
            this.debugLogging = debugLogging;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbProxyRequest build() {
            return new ModifyDbProxyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbProxyRequest> {
        public Builder dbProxyName(String var1);

        public Builder newDBProxyName(String var1);

        public Builder auth(Collection<UserAuthConfig> var1);

        public Builder auth(UserAuthConfig ... var1);

        public Builder auth(Consumer<UserAuthConfig.Builder> ... var1);

        public Builder requireTLS(Boolean var1);

        public Builder idleClientTimeout(Integer var1);

        public Builder debugLogging(Boolean var1);

        public Builder roleArn(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

