/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedDbInstancesOfferingsRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, DescribeReservedDbInstancesOfferingsRequest> {
    private static final SdkField<String> RESERVED_DB_INSTANCES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedDBInstancesOfferingId").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::reservedDBInstancesOfferingId)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::reservedDBInstancesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedDBInstancesOfferingId").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::dbInstanceClass)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Duration").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::duration)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::productDescription)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::offeringType)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::multiAZ)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::filters)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecords").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::maxRecords)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::maxRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeReservedDbInstancesOfferingsRequest.getter(DescribeReservedDbInstancesOfferingsRequest::marker)).setter(DescribeReservedDbInstancesOfferingsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_DB_INSTANCES_OFFERING_ID_FIELD, DB_INSTANCE_CLASS_FIELD, DURATION_FIELD, PRODUCT_DESCRIPTION_FIELD, OFFERING_TYPE_FIELD, MULTI_AZ_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));
    private final String reservedDBInstancesOfferingId;
    private final String dbInstanceClass;
    private final String duration;
    private final String productDescription;
    private final String offeringType;
    private final Boolean multiAZ;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeReservedDbInstancesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public final String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final String duration() {
        return this.duration;
    }

    public final String productDescription() {
        return this.productDescription;
    }

    public final String offeringType() {
        return this.offeringType;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Integer maxRecords() {
        return this.maxRecords;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedDBInstancesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringType());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDbInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedDbInstancesOfferingsRequest other = (DescribeReservedDbInstancesOfferingsRequest)((Object)obj);
        return Objects.equals(this.reservedDBInstancesOfferingId(), other.reservedDBInstancesOfferingId()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.productDescription(), other.productDescription()) && Objects.equals(this.offeringType(), other.offeringType()) && Objects.equals(this.multiAZ(), other.multiAZ()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedDbInstancesOfferingsRequest").add("ReservedDBInstancesOfferingId", (Object)this.reservedDBInstancesOfferingId()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Duration", (Object)this.duration()).add("ProductDescription", (Object)this.productDescription()).add("OfferingType", (Object)this.offeringType()).add("MultiAZ", (Object)this.multiAZ()).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxRecords", (Object)this.maxRecords()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedDBInstancesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedDBInstancesOfferingId()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescription()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringType()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedDbInstancesOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeReservedDbInstancesOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String reservedDBInstancesOfferingId;
        private String dbInstanceClass;
        private String duration;
        private String productDescription;
        private String offeringType;
        private Boolean multiAZ;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDbInstancesOfferingsRequest model) {
            super(model);
            this.reservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.dbInstanceClass(model.dbInstanceClass);
            this.duration(model.duration);
            this.productDescription(model.productDescription);
            this.offeringType(model.offeringType);
            this.multiAZ(model.multiAZ);
            this.filters(model.filters);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getDuration() {
            return this.duration;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedDbInstancesOfferingsRequest build() {
            return new DescribeReservedDbInstancesOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedDbInstancesOfferingsRequest> {
        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder duration(String var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

