/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesRequest;
import software.amazon.awssdk.services.rds.model.DescribeTenantDatabasesResponse;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.waiters.RdsAsyncWaiter;
import software.amazon.awssdk.services.rds.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultRdsAsyncWaiter
implements RdsAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final RdsAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeDbInstancesResponse> dBInstanceAvailableWaiter;
    private final AsyncWaiter<DescribeDbInstancesResponse> dBInstanceDeletedWaiter;
    private final AsyncWaiter<DescribeDbSnapshotsResponse> dBSnapshotAvailableWaiter;
    private final AsyncWaiter<DescribeDbSnapshotsResponse> dBSnapshotDeletedWaiter;
    private final AsyncWaiter<DescribeDbClusterSnapshotsResponse> dBClusterSnapshotAvailableWaiter;
    private final AsyncWaiter<DescribeDbClusterSnapshotsResponse> dBClusterSnapshotDeletedWaiter;
    private final AsyncWaiter<DescribeDbClustersResponse> dBClusterAvailableWaiter;
    private final AsyncWaiter<DescribeDbClustersResponse> dBClusterDeletedWaiter;
    private final AsyncWaiter<DescribeTenantDatabasesResponse> tenantDatabaseAvailableWaiter;
    private final AsyncWaiter<DescribeTenantDatabasesResponse> tenantDatabaseDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultRdsAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (RdsAsyncClient)RdsAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.dBInstanceAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbInstancesResponse.class).acceptors(DefaultRdsAsyncWaiter.dBInstanceAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBInstanceAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBInstanceDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbInstancesResponse.class).acceptors(DefaultRdsAsyncWaiter.dBInstanceDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBInstanceDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBSnapshotAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbSnapshotsResponse.class).acceptors(DefaultRdsAsyncWaiter.dBSnapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBSnapshotAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBSnapshotDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbSnapshotsResponse.class).acceptors(DefaultRdsAsyncWaiter.dBSnapshotDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBSnapshotDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBClusterSnapshotAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbClusterSnapshotsResponse.class).acceptors(DefaultRdsAsyncWaiter.dBClusterSnapshotAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBClusterSnapshotAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBClusterSnapshotDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbClusterSnapshotsResponse.class).acceptors(DefaultRdsAsyncWaiter.dBClusterSnapshotDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBClusterSnapshotDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBClusterAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbClustersResponse.class).acceptors(DefaultRdsAsyncWaiter.dBClusterAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBClusterAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.dBClusterDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeDbClustersResponse.class).acceptors(DefaultRdsAsyncWaiter.dBClusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.dBClusterDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.tenantDatabaseAvailableWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTenantDatabasesResponse.class).acceptors(DefaultRdsAsyncWaiter.tenantDatabaseAvailableWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.tenantDatabaseAvailableWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.tenantDatabaseDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeTenantDatabasesResponse.class).acceptors(DefaultRdsAsyncWaiter.tenantDatabaseDeletedWaiterAcceptors())).overrideConfiguration(DefaultRdsAsyncWaiter.tenantDatabaseDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClustersResponse>> waitUntilDBClusterAvailable(DescribeDbClustersRequest describeDbClustersRequest) {
        return this.dBClusterAvailableWaiter.runAsync(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClustersResponse>> waitUntilDBClusterAvailable(DescribeDbClustersRequest describeDbClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterAvailableWaiter.runAsync(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)), DefaultRdsAsyncWaiter.dBClusterAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClustersResponse>> waitUntilDBClusterDeleted(DescribeDbClustersRequest describeDbClustersRequest) {
        return this.dBClusterDeletedWaiter.runAsync(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClustersResponse>> waitUntilDBClusterDeleted(DescribeDbClustersRequest describeDbClustersRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterDeletedWaiter.runAsync(() -> this.client.describeDBClusters(this.applyWaitersUserAgent(describeDbClustersRequest)), DefaultRdsAsyncWaiter.dBClusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClusterSnapshotsResponse>> waitUntilDBClusterSnapshotAvailable(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        return this.dBClusterSnapshotAvailableWaiter.runAsync(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClusterSnapshotsResponse>> waitUntilDBClusterSnapshotAvailable(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterSnapshotAvailableWaiter.runAsync(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)), DefaultRdsAsyncWaiter.dBClusterSnapshotAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClusterSnapshotsResponse>> waitUntilDBClusterSnapshotDeleted(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) {
        return this.dBClusterSnapshotDeletedWaiter.runAsync(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbClusterSnapshotsResponse>> waitUntilDBClusterSnapshotDeleted(DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBClusterSnapshotDeletedWaiter.runAsync(() -> this.client.describeDBClusterSnapshots(this.applyWaitersUserAgent(describeDbClusterSnapshotsRequest)), DefaultRdsAsyncWaiter.dBClusterSnapshotDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceAvailable(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return this.dBInstanceAvailableWaiter.runAsync(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceAvailable(DescribeDbInstancesRequest describeDbInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBInstanceAvailableWaiter.runAsync(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)), DefaultRdsAsyncWaiter.dBInstanceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceDeleted(DescribeDbInstancesRequest describeDbInstancesRequest) {
        return this.dBInstanceDeletedWaiter.runAsync(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbInstancesResponse>> waitUntilDBInstanceDeleted(DescribeDbInstancesRequest describeDbInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBInstanceDeletedWaiter.runAsync(() -> this.client.describeDBInstances(this.applyWaitersUserAgent(describeDbInstancesRequest)), DefaultRdsAsyncWaiter.dBInstanceDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbSnapshotsResponse>> waitUntilDBSnapshotAvailable(DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        return this.dBSnapshotAvailableWaiter.runAsync(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbSnapshotsResponse>> waitUntilDBSnapshotAvailable(DescribeDbSnapshotsRequest describeDbSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBSnapshotAvailableWaiter.runAsync(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)), DefaultRdsAsyncWaiter.dBSnapshotAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbSnapshotsResponse>> waitUntilDBSnapshotDeleted(DescribeDbSnapshotsRequest describeDbSnapshotsRequest) {
        return this.dBSnapshotDeletedWaiter.runAsync(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeDbSnapshotsResponse>> waitUntilDBSnapshotDeleted(DescribeDbSnapshotsRequest describeDbSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.dBSnapshotDeletedWaiter.runAsync(() -> this.client.describeDBSnapshots(this.applyWaitersUserAgent(describeDbSnapshotsRequest)), DefaultRdsAsyncWaiter.dBSnapshotDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTenantDatabasesResponse>> waitUntilTenantDatabaseAvailable(DescribeTenantDatabasesRequest describeTenantDatabasesRequest) {
        return this.tenantDatabaseAvailableWaiter.runAsync(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTenantDatabasesResponse>> waitUntilTenantDatabaseAvailable(DescribeTenantDatabasesRequest describeTenantDatabasesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tenantDatabaseAvailableWaiter.runAsync(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)), DefaultRdsAsyncWaiter.tenantDatabaseAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTenantDatabasesResponse>> waitUntilTenantDatabaseDeleted(DescribeTenantDatabasesRequest describeTenantDatabasesRequest) {
        return this.tenantDatabaseDeletedWaiter.runAsync(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeTenantDatabasesResponse>> waitUntilTenantDatabaseDeleted(DescribeTenantDatabasesRequest describeTenantDatabasesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.tenantDatabaseDeletedWaiter.runAsync(() -> this.client.describeTenantDatabases(this.applyWaitersUserAgent(describeTenantDatabasesRequest)), DefaultRdsAsyncWaiter.tenantDatabaseDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeDbInstancesResponse>> dBInstanceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbInstancesResponse>> dBInstanceDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBInstances").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsAsyncWaiter.errorCode(error), "DBInstanceNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBInstances").flatten().field("DBInstanceStatus").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> dBSnapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> dBSnapshotDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBSnapshots").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsAsyncWaiter.errorCode(error), "DBSnapshotNotFound")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> dBClusterSnapshotAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> dBClusterSnapshotDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClusterSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBClusterSnapshots").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsAsyncWaiter.errorCode(error), "DBClusterSnapshotNotFoundFault")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusterSnapshots").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClustersResponse>> dBClusterAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeDbClustersResponse>> dBClusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeDbClustersResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("DBClusters").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsAsyncWaiter.errorCode(error), "DBClusterNotFoundFault")));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "creating"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "modifying"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "rebooting"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("DBClusters").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "resetting-master-credentials"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> tenantDatabaseAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-parameters"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("TenantDatabases").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "incompatible-restore"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> tenantDatabaseDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeTenantDatabasesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            return Objects.equals(input.field("TenantDatabases").length().compare("==", input.constant(0)).value(), true);
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultRdsAsyncWaiter.errorCode(error), "DBInstanceNotFoundFault")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration dBInstanceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBInstanceDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBSnapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBSnapshotDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterSnapshotAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterSnapshotDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration dBClusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tenantDatabaseAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration tenantDatabaseDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static RdsAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends RdsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((RdsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements RdsAsyncWaiter.Builder {
        private RdsAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public RdsAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public RdsAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public RdsAsyncWaiter.Builder client(RdsAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public RdsAsyncWaiter build() {
            return new DefaultRdsAsyncWaiter(this);
        }
    }
}

