/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AutomationMode;
import software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupNameListCopier;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ReplicaMode;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbInstanceRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbInstanceRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbInstanceIdentifier)).setter(ModifyDbInstanceRequest.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::allocatedStorage)).setter(ModifyDbInstanceRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbInstanceClass)).setter(ModifyDbInstanceRequest.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbSubnetGroupName)).setter(ModifyDbInstanceRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSecurityGroups").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbSecurityGroups)).setter(ModifyDbInstanceRequest.setter(Builder::dbSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(), ListTrait.builder().memberLocationName("DBSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::vpcSecurityGroupIds)).setter(ModifyDbInstanceRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Boolean> APPLY_IMMEDIATELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ApplyImmediately").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::applyImmediately)).setter(ModifyDbInstanceRequest.setter(Builder::applyImmediately)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyImmediately").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::masterUserPassword)).setter(ModifyDbInstanceRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupName").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbParameterGroupName)).setter(ModifyDbInstanceRequest.setter(Builder::dbParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::backupRetentionPeriod)).setter(ModifyDbInstanceRequest.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::preferredBackupWindow)).setter(ModifyDbInstanceRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::preferredMaintenanceWindow)).setter(ModifyDbInstanceRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::multiAZ)).setter(ModifyDbInstanceRequest.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::engineVersion)).setter(ModifyDbInstanceRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> ALLOW_MAJOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowMajorVersionUpgrade").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::allowMajorVersionUpgrade)).setter(ModifyDbInstanceRequest.setter(Builder::allowMajorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMajorVersionUpgrade").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::autoMinorVersionUpgrade)).setter(ModifyDbInstanceRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::licenseModel)).setter(ModifyDbInstanceRequest.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::iops)).setter(ModifyDbInstanceRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::optionGroupName)).setter(ModifyDbInstanceRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> NEW_DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewDBInstanceIdentifier").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::newDBInstanceIdentifier)).setter(ModifyDbInstanceRequest.setter(Builder::newDBInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDBInstanceIdentifier").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::storageType)).setter(ModifyDbInstanceRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialArn").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::tdeCredentialArn)).setter(ModifyDbInstanceRequest.setter(Builder::tdeCredentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()}).build();
    private static final SdkField<String> TDE_CREDENTIAL_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TdeCredentialPassword").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::tdeCredentialPassword)).setter(ModifyDbInstanceRequest.setter(Builder::tdeCredentialPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialPassword").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CACertificateIdentifier").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::caCertificateIdentifier)).setter(ModifyDbInstanceRequest.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::domain)).setter(ModifyDbInstanceRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::copyTagsToSnapshot)).setter(ModifyDbInstanceRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::monitoringInterval)).setter(ModifyDbInstanceRequest.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<Integer> DB_PORT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DBPortNumber").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::dbPortNumber)).setter(ModifyDbInstanceRequest.setter(Builder::dbPortNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBPortNumber").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::publiclyAccessible)).setter(ModifyDbInstanceRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::monitoringRoleArn)).setter(ModifyDbInstanceRequest.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::domainIAMRoleName)).setter(ModifyDbInstanceRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PromotionTier").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::promotionTier)).setter(ModifyDbInstanceRequest.setter(Builder::promotionTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::enableIAMDatabaseAuthentication)).setter(ModifyDbInstanceRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::enablePerformanceInsights)).setter(ModifyDbInstanceRequest.setter(Builder::enablePerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::performanceInsightsKMSKeyId)).setter(ModifyDbInstanceRequest.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::performanceInsightsRetentionPeriod)).setter(ModifyDbInstanceRequest.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<CloudwatchLogsExportConfiguration> CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudwatchLogsExportConfiguration").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::cloudwatchLogsExportConfiguration)).setter(ModifyDbInstanceRequest.setter(Builder::cloudwatchLogsExportConfiguration)).constructor(CloudwatchLogsExportConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsExportConfiguration").build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::processorFeatures)).setter(ModifyDbInstanceRequest.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseDefaultProcessorFeatures").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::useDefaultProcessorFeatures)).setter(ModifyDbInstanceRequest.setter(Builder::useDefaultProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::deletionProtection)).setter(ModifyDbInstanceRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::maxAllocatedStorage)).setter(ModifyDbInstanceRequest.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<Boolean> CERTIFICATE_ROTATION_RESTART_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CertificateRotationRestart").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::certificateRotationRestart)).setter(ModifyDbInstanceRequest.setter(Builder::certificateRotationRestart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateRotationRestart").build()}).build();
    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaMode").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::replicaModeAsString)).setter(ModifyDbInstanceRequest.setter(Builder::replicaMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()}).build();
    private static final SdkField<Boolean> ENABLE_CUSTOMER_OWNED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableCustomerOwnedIp").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::enableCustomerOwnedIp)).setter(ModifyDbInstanceRequest.setter(Builder::enableCustomerOwnedIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCustomerOwnedIp").build()}).build();
    private static final SdkField<String> AWS_BACKUP_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsBackupRecoveryPointArn").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::awsBackupRecoveryPointArn)).setter(ModifyDbInstanceRequest.setter(Builder::awsBackupRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsBackupRecoveryPointArn").build()}).build();
    private static final SdkField<String> AUTOMATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomationMode").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::automationModeAsString)).setter(ModifyDbInstanceRequest.setter(Builder::automationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationMode").build()}).build();
    private static final SdkField<Integer> RESUME_FULL_AUTOMATION_MODE_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ResumeFullAutomationModeMinutes").getter(ModifyDbInstanceRequest.getter(ModifyDbInstanceRequest::resumeFullAutomationModeMinutes)).setter(ModifyDbInstanceRequest.setter(Builder::resumeFullAutomationModeMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumeFullAutomationModeMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD, ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, APPLY_IMMEDIATELY_FIELD, MASTER_USER_PASSWORD_FIELD, DB_PARAMETER_GROUP_NAME_FIELD, BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD, ALLOW_MAJOR_VERSION_UPGRADE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, NEW_DB_INSTANCE_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD, TDE_CREDENTIAL_ARN_FIELD, TDE_CREDENTIAL_PASSWORD_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, DOMAIN_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, DB_PORT_NUMBER_FIELD, PUBLICLY_ACCESSIBLE_FIELD, MONITORING_ROLE_ARN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, PROMOTION_TIER_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, CLOUDWATCH_LOGS_EXPORT_CONFIGURATION_FIELD, PROCESSOR_FEATURES_FIELD, USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, MAX_ALLOCATED_STORAGE_FIELD, CERTIFICATE_ROTATION_RESTART_FIELD, REPLICA_MODE_FIELD, ENABLE_CUSTOMER_OWNED_IP_FIELD, AWS_BACKUP_RECOVERY_POINT_ARN_FIELD, AUTOMATION_MODE_FIELD, RESUME_FULL_AUTOMATION_MODE_MINUTES_FIELD));
    private final String dbInstanceIdentifier;
    private final Integer allocatedStorage;
    private final String dbInstanceClass;
    private final String dbSubnetGroupName;
    private final List<String> dbSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final Boolean applyImmediately;
    private final String masterUserPassword;
    private final String dbParameterGroupName;
    private final Integer backupRetentionPeriod;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean allowMajorVersionUpgrade;
    private final Boolean autoMinorVersionUpgrade;
    private final String licenseModel;
    private final Integer iops;
    private final String optionGroupName;
    private final String newDBInstanceIdentifier;
    private final String storageType;
    private final String tdeCredentialArn;
    private final String tdeCredentialPassword;
    private final String caCertificateIdentifier;
    private final String domain;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final Integer dbPortNumber;
    private final Boolean publiclyAccessible;
    private final String monitoringRoleArn;
    private final String domainIAMRoleName;
    private final Integer promotionTier;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
    private final List<ProcessorFeature> processorFeatures;
    private final Boolean useDefaultProcessorFeatures;
    private final Boolean deletionProtection;
    private final Integer maxAllocatedStorage;
    private final Boolean certificateRotationRestart;
    private final String replicaMode;
    private final Boolean enableCustomerOwnedIp;
    private final String awsBackupRecoveryPointArn;
    private final String automationMode;
    private final Integer resumeFullAutomationModeMinutes;

    private ModifyDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.applyImmediately = builder.applyImmediately;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.newDBInstanceIdentifier = builder.newDBInstanceIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.tdeCredentialPassword = builder.tdeCredentialPassword;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.domain = builder.domain;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.dbPortNumber = builder.dbPortNumber;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.promotionTier = builder.promotionTier;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.cloudwatchLogsExportConfiguration = builder.cloudwatchLogsExportConfiguration;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.certificateRotationRestart = builder.certificateRotationRestart;
        this.replicaMode = builder.replicaMode;
        this.enableCustomerOwnedIp = builder.enableCustomerOwnedIp;
        this.awsBackupRecoveryPointArn = builder.awsBackupRecoveryPointArn;
        this.automationMode = builder.automationMode;
        this.resumeFullAutomationModeMinutes = builder.resumeFullAutomationModeMinutes;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final boolean hasDbSecurityGroups() {
        return this.dbSecurityGroups != null && !(this.dbSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean allowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final String newDBInstanceIdentifier() {
        return this.newDBInstanceIdentifier;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final String tdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public final String tdeCredentialPassword() {
        return this.tdeCredentialPassword;
    }

    public final String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public final String domain() {
        return this.domain;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public final Integer dbPortNumber() {
        return this.dbPortNumber;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public final Integer promotionTier() {
        return this.promotionTier;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public final String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public final Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public final CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration() {
        return this.cloudwatchLogsExportConfiguration;
    }

    public final boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public final List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public final Boolean useDefaultProcessorFeatures() {
        return this.useDefaultProcessorFeatures;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final Boolean certificateRotationRestart() {
        return this.certificateRotationRestart;
    }

    public final ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(this.replicaMode);
    }

    public final String replicaModeAsString() {
        return this.replicaMode;
    }

    public final Boolean enableCustomerOwnedIp() {
        return this.enableCustomerOwnedIp;
    }

    public final String awsBackupRecoveryPointArn() {
        return this.awsBackupRecoveryPointArn;
    }

    public final AutomationMode automationMode() {
        return AutomationMode.fromValue(this.automationMode);
    }

    public final String automationModeAsString() {
        return this.automationMode;
    }

    public final Integer resumeFullAutomationModeMinutes() {
        return this.resumeFullAutomationModeMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDBInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tdeCredentialPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbPortNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudwatchLogsExportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateRotationRestart());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableCustomerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsBackupRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.automationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resumeFullAutomationModeMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbInstanceRequest)) {
            return false;
        }
        ModifyDbInstanceRequest other = (ModifyDbInstanceRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && this.hasDbSecurityGroups() == other.hasDbSecurityGroups() && Objects.equals(this.dbSecurityGroups(), other.dbSecurityGroups()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.newDBInstanceIdentifier(), other.newDBInstanceIdentifier()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(this.tdeCredentialPassword(), other.tdeCredentialPassword()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.dbPortNumber(), other.dbPortNumber()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.promotionTier(), other.promotionTier()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && Objects.equals(this.cloudwatchLogsExportConfiguration(), other.cloudwatchLogsExportConfiguration()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.certificateRotationRestart(), other.certificateRotationRestart()) && Objects.equals(this.replicaModeAsString(), other.replicaModeAsString()) && Objects.equals(this.enableCustomerOwnedIp(), other.enableCustomerOwnedIp()) && Objects.equals(this.awsBackupRecoveryPointArn(), other.awsBackupRecoveryPointArn()) && Objects.equals(this.automationModeAsString(), other.automationModeAsString()) && Objects.equals(this.resumeFullAutomationModeMinutes(), other.resumeFullAutomationModeMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbInstanceRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("DBSecurityGroups", this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("ApplyImmediately", (Object)this.applyImmediately()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AllowMajorVersionUpgrade", (Object)this.allowMajorVersionUpgrade()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("LicenseModel", (Object)this.licenseModel()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("NewDBInstanceIdentifier", (Object)this.newDBInstanceIdentifier()).add("StorageType", (Object)this.storageType()).add("TdeCredentialArn", (Object)this.tdeCredentialArn()).add("TdeCredentialPassword", (Object)this.tdeCredentialPassword()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("Domain", (Object)this.domain()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("DBPortNumber", (Object)this.dbPortNumber()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).add("PromotionTier", (Object)this.promotionTier()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("CloudwatchLogsExportConfiguration", (Object)this.cloudwatchLogsExportConfiguration()).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("UseDefaultProcessorFeatures", (Object)this.useDefaultProcessorFeatures()).add("DeletionProtection", (Object)this.deletionProtection()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("CertificateRotationRestart", (Object)this.certificateRotationRestart()).add("ReplicaMode", (Object)this.replicaModeAsString()).add("EnableCustomerOwnedIp", (Object)this.enableCustomerOwnedIp()).add("AwsBackupRecoveryPointArn", (Object)this.awsBackupRecoveryPointArn()).add("AutomationMode", (Object)this.automationModeAsString()).add("ResumeFullAutomationModeMinutes", (Object)this.resumeFullAutomationModeMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "DBSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "DBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupName()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AllowMajorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowMajorVersionUpgrade()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "NewDBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.newDBInstanceIdentifier()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "TdeCredentialArn": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialArn()));
            }
            case "TdeCredentialPassword": {
                return Optional.ofNullable(clazz.cast(this.tdeCredentialPassword()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "DBPortNumber": {
                return Optional.ofNullable(clazz.cast(this.dbPortNumber()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
            case "PromotionTier": {
                return Optional.ofNullable(clazz.cast(this.promotionTier()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "CloudwatchLogsExportConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cloudwatchLogsExportConfiguration()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "UseDefaultProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.useDefaultProcessorFeatures()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "CertificateRotationRestart": {
                return Optional.ofNullable(clazz.cast(this.certificateRotationRestart()));
            }
            case "ReplicaMode": {
                return Optional.ofNullable(clazz.cast(this.replicaModeAsString()));
            }
            case "EnableCustomerOwnedIp": {
                return Optional.ofNullable(clazz.cast(this.enableCustomerOwnedIp()));
            }
            case "AwsBackupRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.awsBackupRecoveryPointArn()));
            }
            case "AutomationMode": {
                return Optional.ofNullable(clazz.cast(this.automationModeAsString()));
            }
            case "ResumeFullAutomationModeMinutes": {
                return Optional.ofNullable(clazz.cast(this.resumeFullAutomationModeMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbInstanceRequest, T> g) {
        return obj -> g.apply((ModifyDbInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Integer allocatedStorage;
        private String dbInstanceClass;
        private String dbSubnetGroupName;
        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean applyImmediately;
        private String masterUserPassword;
        private String dbParameterGroupName;
        private Integer backupRetentionPeriod;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean allowMajorVersionUpgrade;
        private Boolean autoMinorVersionUpgrade;
        private String licenseModel;
        private Integer iops;
        private String optionGroupName;
        private String newDBInstanceIdentifier;
        private String storageType;
        private String tdeCredentialArn;
        private String tdeCredentialPassword;
        private String caCertificateIdentifier;
        private String domain;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private Integer dbPortNumber;
        private Boolean publiclyAccessible;
        private String monitoringRoleArn;
        private String domainIAMRoleName;
        private Integer promotionTier;
        private Boolean enableIAMDatabaseAuthentication;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration;
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultProcessorFeatures;
        private Boolean deletionProtection;
        private Integer maxAllocatedStorage;
        private Boolean certificateRotationRestart;
        private String replicaMode;
        private Boolean enableCustomerOwnedIp;
        private String awsBackupRecoveryPointArn;
        private String automationMode;
        private Integer resumeFullAutomationModeMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbInstanceRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.allocatedStorage(model.allocatedStorage);
            this.dbInstanceClass(model.dbInstanceClass);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.dbSecurityGroups(model.dbSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.applyImmediately(model.applyImmediately);
            this.masterUserPassword(model.masterUserPassword);
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.licenseModel(model.licenseModel);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.newDBInstanceIdentifier(model.newDBInstanceIdentifier);
            this.storageType(model.storageType);
            this.tdeCredentialArn(model.tdeCredentialArn);
            this.tdeCredentialPassword(model.tdeCredentialPassword);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.domain(model.domain);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.monitoringInterval(model.monitoringInterval);
            this.dbPortNumber(model.dbPortNumber);
            this.publiclyAccessible(model.publiclyAccessible);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.promotionTier(model.promotionTier);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.cloudwatchLogsExportConfiguration(model.cloudwatchLogsExportConfiguration);
            this.processorFeatures(model.processorFeatures);
            this.useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            this.deletionProtection(model.deletionProtection);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.certificateRotationRestart(model.certificateRotationRestart);
            this.replicaMode(model.replicaMode);
            this.enableCustomerOwnedIp(model.enableCustomerOwnedIp);
            this.awsBackupRecoveryPointArn(model.awsBackupRecoveryPointArn);
            this.automationMode(model.automationMode);
            this.resumeFullAutomationModeMinutes(model.resumeFullAutomationModeMinutes);
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        @Transient
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        @Transient
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        @Transient
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (this.dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbSecurityGroups;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        @Override
        @Transient
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dbSecurityGroups(String ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        @Transient
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        @Override
        @Transient
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        @Transient
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getDbParameterGroupName() {
            return this.dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        @Transient
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        @Transient
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        @Transient
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        @Transient
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return this.allowMajorVersionUpgrade;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        @Transient
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        @Transient
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        @Transient
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getNewDBInstanceIdentifier() {
            return this.newDBInstanceIdentifier;
        }

        public final void setNewDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder newDBInstanceIdentifier(String newDBInstanceIdentifier) {
            this.newDBInstanceIdentifier = newDBInstanceIdentifier;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getTdeCredentialArn() {
            return this.tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        @Transient
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final String getTdeCredentialPassword() {
            return this.tdeCredentialPassword;
        }

        public final void setTdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
        }

        @Override
        @Transient
        public final Builder tdeCredentialPassword(String tdeCredentialPassword) {
            this.tdeCredentialPassword = tdeCredentialPassword;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        @Transient
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        @Transient
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        @Transient
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final Integer getDbPortNumber() {
            return this.dbPortNumber;
        }

        public final void setDbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
        }

        @Override
        @Transient
        public final Builder dbPortNumber(Integer dbPortNumber) {
            this.dbPortNumber = dbPortNumber;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        @Transient
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        @Transient
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        @Transient
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final Integer getPromotionTier() {
            return this.promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        @Transient
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        @Transient
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        @Transient
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        @Transient
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final CloudwatchLogsExportConfiguration.Builder getCloudwatchLogsExportConfiguration() {
            return this.cloudwatchLogsExportConfiguration != null ? this.cloudwatchLogsExportConfiguration.toBuilder() : null;
        }

        public final void setCloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration.BuilderImpl cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration != null ? cloudwatchLogsExportConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration cloudwatchLogsExportConfiguration) {
            this.cloudwatchLogsExportConfiguration = cloudwatchLogsExportConfiguration;
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        @Transient
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return this.useDefaultProcessorFeatures;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        @Override
        @Transient
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        @Transient
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        @Transient
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final Boolean getCertificateRotationRestart() {
            return this.certificateRotationRestart;
        }

        public final void setCertificateRotationRestart(Boolean certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
        }

        @Override
        @Transient
        public final Builder certificateRotationRestart(Boolean certificateRotationRestart) {
            this.certificateRotationRestart = certificateRotationRestart;
            return this;
        }

        public final String getReplicaMode() {
            return this.replicaMode;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        @Override
        @Transient
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        @Transient
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        public final Boolean getEnableCustomerOwnedIp() {
            return this.enableCustomerOwnedIp;
        }

        public final void setEnableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
        }

        @Override
        @Transient
        public final Builder enableCustomerOwnedIp(Boolean enableCustomerOwnedIp) {
            this.enableCustomerOwnedIp = enableCustomerOwnedIp;
            return this;
        }

        public final String getAwsBackupRecoveryPointArn() {
            return this.awsBackupRecoveryPointArn;
        }

        public final void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
        }

        @Override
        @Transient
        public final Builder awsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
            this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
            return this;
        }

        public final String getAutomationMode() {
            return this.automationMode;
        }

        public final void setAutomationMode(String automationMode) {
            this.automationMode = automationMode;
        }

        @Override
        @Transient
        public final Builder automationMode(String automationMode) {
            this.automationMode = automationMode;
            return this;
        }

        @Override
        @Transient
        public final Builder automationMode(AutomationMode automationMode) {
            this.automationMode(automationMode == null ? null : automationMode.toString());
            return this;
        }

        public final Integer getResumeFullAutomationModeMinutes() {
            return this.resumeFullAutomationModeMinutes;
        }

        public final void setResumeFullAutomationModeMinutes(Integer resumeFullAutomationModeMinutes) {
            this.resumeFullAutomationModeMinutes = resumeFullAutomationModeMinutes;
        }

        @Override
        @Transient
        public final Builder resumeFullAutomationModeMinutes(Integer resumeFullAutomationModeMinutes) {
            this.resumeFullAutomationModeMinutes = resumeFullAutomationModeMinutes;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbInstanceRequest build() {
            return new ModifyDbInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder dbInstanceClass(String var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder dbSecurityGroups(Collection<String> var1);

        public Builder dbSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder applyImmediately(Boolean var1);

        public Builder masterUserPassword(String var1);

        public Builder dbParameterGroupName(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder allowMajorVersionUpgrade(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder newDBInstanceIdentifier(String var1);

        public Builder storageType(String var1);

        public Builder tdeCredentialArn(String var1);

        public Builder tdeCredentialPassword(String var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder domain(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder dbPortNumber(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder monitoringRoleArn(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder promotionTier(Integer var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder cloudwatchLogsExportConfiguration(CloudwatchLogsExportConfiguration var1);

        default public Builder cloudwatchLogsExportConfiguration(Consumer<CloudwatchLogsExportConfiguration.Builder> cloudwatchLogsExportConfiguration) {
            return this.cloudwatchLogsExportConfiguration((CloudwatchLogsExportConfiguration)((CloudwatchLogsExportConfiguration.Builder)CloudwatchLogsExportConfiguration.builder().applyMutation(cloudwatchLogsExportConfiguration)).build());
        }

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder useDefaultProcessorFeatures(Boolean var1);

        public Builder deletionProtection(Boolean var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder certificateRotationRestart(Boolean var1);

        public Builder replicaMode(String var1);

        public Builder replicaMode(ReplicaMode var1);

        public Builder enableCustomerOwnedIp(Boolean var1);

        public Builder awsBackupRecoveryPointArn(String var1);

        public Builder automationMode(String var1);

        public Builder automationMode(AutomationMode var1);

        public Builder resumeFullAutomationModeMinutes(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

