/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;

public class DescribeReservedDBInstancesOfferingsIterable
implements SdkIterable<DescribeReservedDbInstancesOfferingsResponse> {
    private final RdsClient client;
    private final DescribeReservedDbInstancesOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesOfferingsIterable(RdsClient client, DescribeReservedDbInstancesOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedDbInstancesOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedDbInstancesOfferingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        Function<DescribeReservedDbInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstancesOfferings() != null) {
                return response.reservedDBInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedDbInstancesOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedDbInstancesOfferingsResponse> {
        private DescribeReservedDbInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDbInstancesOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReservedDbInstancesOfferingsResponse nextPage(DescribeReservedDbInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesOfferingsIterable.this.client.describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedDBInstancesOfferingsIterable.this.client.describeReservedDBInstancesOfferings((DescribeReservedDbInstancesOfferingsRequest)((Object)DescribeReservedDBInstancesOfferingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

