/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.rds.model.Parameter;

public class DescribeEngineDefaultParametersPublisher
implements SdkPublisher<DescribeEngineDefaultParametersResponse> {
    private final RdsAsyncClient client;
    private final DescribeEngineDefaultParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEngineDefaultParametersPublisher(RdsAsyncClient client, DescribeEngineDefaultParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEngineDefaultParametersPublisher(RdsAsyncClient client, DescribeEngineDefaultParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEngineDefaultParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEngineDefaultParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeEngineDefaultParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.engineDefaults() != null && response.engineDefaults().parameters() != null) {
                return response.engineDefaults().parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEngineDefaultParametersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEngineDefaultParametersResponseFetcher
    implements AsyncPageFetcher<DescribeEngineDefaultParametersResponse> {
        private DescribeEngineDefaultParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineDefaultParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.engineDefaults().marker());
        }

        public CompletableFuture<DescribeEngineDefaultParametersResponse> nextPage(DescribeEngineDefaultParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineDefaultParametersPublisher.this.client.describeEngineDefaultParameters(DescribeEngineDefaultParametersPublisher.this.firstRequest);
            }
            return DescribeEngineDefaultParametersPublisher.this.client.describeEngineDefaultParameters((DescribeEngineDefaultParametersRequest)((Object)DescribeEngineDefaultParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.engineDefaults().marker()).build()));
        }
    }
}

