/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbProxyTargetGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbProxyTargetGroupRequest> {
    private static final SdkField<String> TARGET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetGroupName").getter(ModifyDbProxyTargetGroupRequest.getter(ModifyDbProxyTargetGroupRequest::targetGroupName)).setter(ModifyDbProxyTargetGroupRequest.setter(Builder::targetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroupName").build()}).build();
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(ModifyDbProxyTargetGroupRequest.getter(ModifyDbProxyTargetGroupRequest::dbProxyName)).setter(ModifyDbProxyTargetGroupRequest.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<ConnectionPoolConfiguration> CONNECTION_POOL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionPoolConfig").getter(ModifyDbProxyTargetGroupRequest.getter(ModifyDbProxyTargetGroupRequest::connectionPoolConfig)).setter(ModifyDbProxyTargetGroupRequest.setter(Builder::connectionPoolConfig)).constructor(ConnectionPoolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPoolConfig").build()}).build();
    private static final SdkField<String> NEW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewName").getter(ModifyDbProxyTargetGroupRequest.getter(ModifyDbProxyTargetGroupRequest::newName)).setter(ModifyDbProxyTargetGroupRequest.setter(Builder::newName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_NAME_FIELD, DB_PROXY_NAME_FIELD, CONNECTION_POOL_CONFIG_FIELD, NEW_NAME_FIELD));
    private final String targetGroupName;
    private final String dbProxyName;
    private final ConnectionPoolConfiguration connectionPoolConfig;
    private final String newName;

    private ModifyDbProxyTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.targetGroupName = builder.targetGroupName;
        this.dbProxyName = builder.dbProxyName;
        this.connectionPoolConfig = builder.connectionPoolConfig;
        this.newName = builder.newName;
    }

    public final String targetGroupName() {
        return this.targetGroupName;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final ConnectionPoolConfiguration connectionPoolConfig() {
        return this.connectionPoolConfig;
    }

    public final String newName() {
        return this.newName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.newName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbProxyTargetGroupRequest)) {
            return false;
        }
        ModifyDbProxyTargetGroupRequest other = (ModifyDbProxyTargetGroupRequest)((Object)obj);
        return Objects.equals(this.targetGroupName(), other.targetGroupName()) && Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.connectionPoolConfig(), other.connectionPoolConfig()) && Objects.equals(this.newName(), other.newName());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbProxyTargetGroupRequest").add("TargetGroupName", (Object)this.targetGroupName()).add("DBProxyName", (Object)this.dbProxyName()).add("ConnectionPoolConfig", (Object)this.connectionPoolConfig()).add("NewName", (Object)this.newName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroupName": {
                return Optional.ofNullable(clazz.cast(this.targetGroupName()));
            }
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "ConnectionPoolConfig": {
                return Optional.ofNullable(clazz.cast(this.connectionPoolConfig()));
            }
            case "NewName": {
                return Optional.ofNullable(clazz.cast(this.newName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbProxyTargetGroupRequest, T> g) {
        return obj -> g.apply((ModifyDbProxyTargetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String targetGroupName;
        private String dbProxyName;
        private ConnectionPoolConfiguration connectionPoolConfig;
        private String newName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbProxyTargetGroupRequest model) {
            super(model);
            this.targetGroupName(model.targetGroupName);
            this.dbProxyName(model.dbProxyName);
            this.connectionPoolConfig(model.connectionPoolConfig);
            this.newName(model.newName);
        }

        public final String getTargetGroupName() {
            return this.targetGroupName;
        }

        @Override
        public final Builder targetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
            return this;
        }

        public final void setTargetGroupName(String targetGroupName) {
            this.targetGroupName = targetGroupName;
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        public final ConnectionPoolConfiguration.Builder getConnectionPoolConfig() {
            return this.connectionPoolConfig != null ? this.connectionPoolConfig.toBuilder() : null;
        }

        @Override
        public final Builder connectionPoolConfig(ConnectionPoolConfiguration connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig;
            return this;
        }

        public final void setConnectionPoolConfig(ConnectionPoolConfiguration.BuilderImpl connectionPoolConfig) {
            this.connectionPoolConfig = connectionPoolConfig != null ? connectionPoolConfig.build() : null;
        }

        public final String getNewName() {
            return this.newName;
        }

        @Override
        public final Builder newName(String newName) {
            this.newName = newName;
            return this;
        }

        public final void setNewName(String newName) {
            this.newName = newName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbProxyTargetGroupRequest build() {
            return new ModifyDbProxyTargetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbProxyTargetGroupRequest> {
        public Builder targetGroupName(String var1);

        public Builder dbProxyName(String var1);

        public Builder connectionPoolConfig(ConnectionPoolConfiguration var1);

        default public Builder connectionPoolConfig(Consumer<ConnectionPoolConfiguration.Builder> connectionPoolConfig) {
            return this.connectionPoolConfig((ConnectionPoolConfiguration)((ConnectionPoolConfiguration.Builder)ConnectionPoolConfiguration.builder().applyMutation(connectionPoolConfig)).build());
        }

        public Builder newName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

