/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingConfiguration> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacity").getter(ScalingConfiguration.getter(ScalingConfiguration::minCapacity)).setter(ScalingConfiguration.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(ScalingConfiguration.getter(ScalingConfiguration::maxCapacity)).setter(ScalingConfiguration.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Boolean> AUTO_PAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoPause").getter(ScalingConfiguration.getter(ScalingConfiguration::autoPause)).setter(ScalingConfiguration.setter(Builder::autoPause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPause").build()}).build();
    private static final SdkField<Integer> SECONDS_UNTIL_AUTO_PAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondsUntilAutoPause").getter(ScalingConfiguration.getter(ScalingConfiguration::secondsUntilAutoPause)).setter(ScalingConfiguration.setter(Builder::secondsUntilAutoPause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondsUntilAutoPause").build()}).build();
    private static final SdkField<String> TIMEOUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeoutAction").getter(ScalingConfiguration.getter(ScalingConfiguration::timeoutAction)).setter(ScalingConfiguration.setter(Builder::timeoutAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, AUTO_PAUSE_FIELD, SECONDS_UNTIL_AUTO_PAUSE_FIELD, TIMEOUT_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final Boolean autoPause;
    private final Integer secondsUntilAutoPause;
    private final String timeoutAction;

    private ScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.autoPause = builder.autoPause;
        this.secondsUntilAutoPause = builder.secondsUntilAutoPause;
        this.timeoutAction = builder.timeoutAction;
    }

    public final Integer minCapacity() {
        return this.minCapacity;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Boolean autoPause() {
        return this.autoPause;
    }

    public final Integer secondsUntilAutoPause() {
        return this.secondsUntilAutoPause;
    }

    public final String timeoutAction() {
        return this.timeoutAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoPause());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondsUntilAutoPause());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutAction());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingConfiguration)) {
            return false;
        }
        ScalingConfiguration other = (ScalingConfiguration)obj;
        return Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.autoPause(), other.autoPause()) && Objects.equals(this.secondsUntilAutoPause(), other.secondsUntilAutoPause()) && Objects.equals(this.timeoutAction(), other.timeoutAction());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingConfiguration").add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("AutoPause", (Object)this.autoPause()).add("SecondsUntilAutoPause", (Object)this.secondsUntilAutoPause()).add("TimeoutAction", (Object)this.timeoutAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "AutoPause": {
                return Optional.ofNullable(clazz.cast(this.autoPause()));
            }
            case "SecondsUntilAutoPause": {
                return Optional.ofNullable(clazz.cast(this.secondsUntilAutoPause()));
            }
            case "TimeoutAction": {
                return Optional.ofNullable(clazz.cast(this.timeoutAction()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingConfiguration, T> g) {
        return obj -> g.apply((ScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minCapacity;
        private Integer maxCapacity;
        private Boolean autoPause;
        private Integer secondsUntilAutoPause;
        private String timeoutAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingConfiguration model) {
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.autoPause(model.autoPause);
            this.secondsUntilAutoPause(model.secondsUntilAutoPause);
            this.timeoutAction(model.timeoutAction);
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        public final Boolean getAutoPause() {
            return this.autoPause;
        }

        @Override
        public final Builder autoPause(Boolean autoPause) {
            this.autoPause = autoPause;
            return this;
        }

        public final void setAutoPause(Boolean autoPause) {
            this.autoPause = autoPause;
        }

        public final Integer getSecondsUntilAutoPause() {
            return this.secondsUntilAutoPause;
        }

        @Override
        public final Builder secondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
            return this;
        }

        public final void setSecondsUntilAutoPause(Integer secondsUntilAutoPause) {
            this.secondsUntilAutoPause = secondsUntilAutoPause;
        }

        public final String getTimeoutAction() {
            return this.timeoutAction;
        }

        @Override
        public final Builder timeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
            return this;
        }

        public final void setTimeoutAction(String timeoutAction) {
            this.timeoutAction = timeoutAction;
        }

        public ScalingConfiguration build() {
            return new ScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingConfiguration> {
        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder autoPause(Boolean var1);

        public Builder secondsUntilAutoPause(Integer var1);

        public Builder timeoutAction(String var1);
    }
}

