/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudwatchLogsExportConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudwatchLogsExportConfiguration> {
    private static final SdkField<List<String>> ENABLE_LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CloudwatchLogsExportConfiguration.getter(CloudwatchLogsExportConfiguration::enableLogTypes)).setter(CloudwatchLogsExportConfiguration.setter(Builder::enableLogTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISABLE_LOG_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CloudwatchLogsExportConfiguration.getter(CloudwatchLogsExportConfiguration::disableLogTypes)).setter(CloudwatchLogsExportConfiguration.setter(Builder::disableLogTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableLogTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_LOG_TYPES_FIELD, DISABLE_LOG_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> enableLogTypes;
    private final List<String> disableLogTypes;

    private CloudwatchLogsExportConfiguration(BuilderImpl builder) {
        this.enableLogTypes = builder.enableLogTypes;
        this.disableLogTypes = builder.disableLogTypes;
    }

    public boolean hasEnableLogTypes() {
        return this.enableLogTypes != null && !(this.enableLogTypes instanceof SdkAutoConstructList);
    }

    public List<String> enableLogTypes() {
        return this.enableLogTypes;
    }

    public boolean hasDisableLogTypes() {
        return this.disableLogTypes != null && !(this.disableLogTypes instanceof SdkAutoConstructList);
    }

    public List<String> disableLogTypes() {
        return this.disableLogTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enableLogTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableLogTypes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchLogsExportConfiguration)) {
            return false;
        }
        CloudwatchLogsExportConfiguration other = (CloudwatchLogsExportConfiguration)obj;
        return Objects.equals(this.enableLogTypes(), other.enableLogTypes()) && Objects.equals(this.disableLogTypes(), other.disableLogTypes());
    }

    public String toString() {
        return ToString.builder((String)"CloudwatchLogsExportConfiguration").add("EnableLogTypes", this.enableLogTypes()).add("DisableLogTypes", this.disableLogTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableLogTypes": {
                return Optional.ofNullable(clazz.cast(this.enableLogTypes()));
            }
            case "DisableLogTypes": {
                return Optional.ofNullable(clazz.cast(this.disableLogTypes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchLogsExportConfiguration, T> g) {
        return obj -> g.apply((CloudwatchLogsExportConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> enableLogTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> disableLogTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchLogsExportConfiguration model) {
            this.enableLogTypes(model.enableLogTypes);
            this.disableLogTypes(model.disableLogTypes);
        }

        public final Collection<String> getEnableLogTypes() {
            return this.enableLogTypes;
        }

        @Override
        public final Builder enableLogTypes(Collection<String> enableLogTypes) {
            this.enableLogTypes = LogTypeListCopier.copy(enableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableLogTypes(String ... enableLogTypes) {
            this.enableLogTypes(Arrays.asList(enableLogTypes));
            return this;
        }

        public final void setEnableLogTypes(Collection<String> enableLogTypes) {
            this.enableLogTypes = LogTypeListCopier.copy(enableLogTypes);
        }

        public final Collection<String> getDisableLogTypes() {
            return this.disableLogTypes;
        }

        @Override
        public final Builder disableLogTypes(Collection<String> disableLogTypes) {
            this.disableLogTypes = LogTypeListCopier.copy(disableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disableLogTypes(String ... disableLogTypes) {
            this.disableLogTypes(Arrays.asList(disableLogTypes));
            return this;
        }

        public final void setDisableLogTypes(Collection<String> disableLogTypes) {
            this.disableLogTypes = LogTypeListCopier.copy(disableLogTypes);
        }

        public CloudwatchLogsExportConfiguration build() {
            return new CloudwatchLogsExportConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudwatchLogsExportConfiguration> {
        public Builder enableLogTypes(Collection<String> var1);

        public Builder enableLogTypes(String ... var1);

        public Builder disableLogTypes(Collection<String> var1);

        public Builder disableLogTypes(String ... var1);
    }
}

