/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.StartDBInstanceRequest;

public class StartDBInstanceRequestMarshaller
implements Marshaller<Request<StartDBInstanceRequest>, StartDBInstanceRequest> {
    public Request<StartDBInstanceRequest> marshall(StartDBInstanceRequest startDBInstanceRequest) {
        if (startDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)startDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "StartDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (startDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)startDBInstanceRequest.dbInstanceIdentifier()));
        }
        return request;
    }
}

