/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeReservedDBInstancesRequestMarshaller
implements Marshaller<Request<DescribeReservedDBInstancesRequest>, DescribeReservedDBInstancesRequest> {
    public Request<DescribeReservedDBInstancesRequest> marshall(DescribeReservedDBInstancesRequest describeReservedDBInstancesRequest) {
        List<Filter> filtersList;
        if (describeReservedDBInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeReservedDBInstancesRequest, "RDSClient");
        request.addParameter("Action", "DescribeReservedDBInstances");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedDBInstancesRequest.reservedDBInstanceId() != null) {
            request.addParameter("ReservedDBInstanceId", StringUtils.fromString((String)describeReservedDBInstancesRequest.reservedDBInstanceId()));
        }
        if (describeReservedDBInstancesRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringUtils.fromString((String)describeReservedDBInstancesRequest.reservedDBInstancesOfferingId()));
        }
        if (describeReservedDBInstancesRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)describeReservedDBInstancesRequest.dbInstanceClass()));
        }
        if (describeReservedDBInstancesRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromString((String)describeReservedDBInstancesRequest.duration()));
        }
        if (describeReservedDBInstancesRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedDBInstancesRequest.productDescription()));
        }
        if (describeReservedDBInstancesRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedDBInstancesRequest.offeringType()));
        }
        if (describeReservedDBInstancesRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)describeReservedDBInstancesRequest.multiAZ()));
        }
        if ((filtersList = describeReservedDBInstancesRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeReservedDBInstancesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeReservedDBInstancesRequest.maxRecords()));
        }
        if (describeReservedDBInstancesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeReservedDBInstancesRequest.marker()));
        }
        return request;
    }
}

