/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeOrderableDBInstanceOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableDBInstanceOptionsRequest>, DescribeOrderableDBInstanceOptionsRequest> {
    public Request<DescribeOrderableDBInstanceOptionsRequest> marshall(DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) {
        List<Filter> filtersList;
        if (describeOrderableDBInstanceOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeOrderableDBInstanceOptionsRequest, "RDSClient");
        request.addParameter("Action", "DescribeOrderableDBInstanceOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableDBInstanceOptionsRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.engine()));
        }
        if (describeOrderableDBInstanceOptionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.engineVersion()));
        }
        if (describeOrderableDBInstanceOptionsRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.dbInstanceClass()));
        }
        if (describeOrderableDBInstanceOptionsRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.licenseModel()));
        }
        if (describeOrderableDBInstanceOptionsRequest.vpc() != null) {
            request.addParameter("Vpc", StringUtils.fromBoolean((Boolean)describeOrderableDBInstanceOptionsRequest.vpc()));
        }
        if ((filtersList = describeOrderableDBInstanceOptionsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeOrderableDBInstanceOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOrderableDBInstanceOptionsRequest.maxRecords()));
        }
        if (describeOrderableDBInstanceOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOrderableDBInstanceOptionsRequest.marker()));
        }
        return request;
    }
}

